package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <Application>
*/
public class Application extends ComplexType
{
  public Application()
  {
  }
  
  public void setVariable(int index, Variable Variable)
  {
    setElementValue(index, "Variable", Variable);
  }
  
  public Variable getVariable(int index)
  {
    return (Variable) getElementValue("Variable", "Variable", index);
  }
  
  public int getVariableCount()
  {
    return sizeOfElement("Variable");
  }
  
  public boolean removeVariable(int index)
  {
    return removeElement(index, "Variable");
  }
  
  public void setParameter(int index, Parameter Parameter)
  {
    setElementValue(index, "Parameter", Parameter);
  }
  
  public Parameter getParameter(int index)
  {
    return (Parameter) getElementValue("Parameter", "Parameter", index);
  }
  
  public int getParameterCount()
  {
    return sizeOfElement("Parameter");
  }
  
  public boolean removeParameter(int index)
  {
    return removeElement(index, "Parameter");
  }
  
  public void setConfiguration(String configuration)
  {
    setAttributeValue("configuration", configuration);
  }
  
  public String getConfiguration()
  {
    return getAttributeValue("configuration");
  }
  
  public boolean removeConfiguration()
  {
    return removeAttribute("configuration");
  }
  
  public void setExecutable(String executable)
  {
    setAttributeValue("executable", executable);
  }
  
  public String getExecutable()
  {
    return getAttributeValue("executable");
  }
  
  public boolean removeExecutable()
  {
    return removeAttribute("executable");
  }
  
  public void setPath(String path)
  {
    setAttributeValue("path", path);
  }
  
  public String getPath()
  {
    return getAttributeValue("path");
  }
  
  public boolean removePath()
  {
    return removeAttribute("path");
  }
  
  public void setLocation(String location)
  {
    setAttributeValue("location", location);
  }
  
  public String getLocation()
  {
    return getAttributeValue("location");
  }
  
  public boolean removeLocation()
  {
    return removeAttribute("location");
  }
  
}

