package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <Hosts>
*/
public class Hosts extends ComplexType
{
  public Hosts()
  {
  }
  
  public void setAllow(int index, Allow Allow)
  {
    setElementValue(index, "Allow", Allow);
  }
  
  public Allow getAllow(int index)
  {
    return (Allow) getElementValue("Allow", "Allow", index);
  }
  
  public int getAllowCount()
  {
    return sizeOfElement("Allow");
  }
  
  public boolean removeAllow(int index)
  {
    return removeElement(index, "Allow");
  }
  
  public void setDeny(int index, Deny Deny)
  {
    setElementValue(index, "Deny", Deny);
  }
  
  public Deny getDeny(int index)
  {
    return (Deny) getElementValue("Deny", "Deny", index);
  }
  
  public int getDenyCount()
  {
    return sizeOfElement("Deny");
  }
  
  public boolean removeDeny(int index)
  {
    return removeElement(index, "Deny");
  }
  
  public void setConfiguration(String configuration)
  {
    setAttributeValue("configuration", configuration);
  }
  
  public String getConfiguration()
  {
    return getAttributeValue("configuration");
  }
  
  public boolean removeConfiguration()
  {
    return removeAttribute("configuration");
  }
  
}

