/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;

import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;

import org.eclipse.hyades.models.hierarchy.impl.AbstractDefaultEventImpl;

import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Default Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEDefaultEventImpl#isAnalyzed <em>Analyzed</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEDefaultEventImpl#getExtensionName <em>Extension Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEDefaultEventImpl#getSymptoms <em>Symptoms</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEDefaultEventImpl#getExtendedProperties <em>Extended Properties</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CBEDefaultEventImpl extends AbstractDefaultEventImpl implements CBEDefaultEvent {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #isAnalyzed() <em>Analyzed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnalyzed()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANALYZED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAnalyzed() <em>Analyzed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnalyzed()
	 * @generated
	 * @ordered
	 */
	protected boolean analyzed = ANALYZED_EDEFAULT;

	/**
	 * The default value of the '{@link #getExtensionName() <em>Extension Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtensionName()
	 * @generated
	 * @ordered
	 */
	protected static final String EXTENSION_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getExtensionName() <em>Extension Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtensionName()
	 * @generated
	 * @ordered
	 */
	protected String extensionName = EXTENSION_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSymptoms() <em>Symptoms</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymptoms()
	 * @generated
	 * @ordered
	 */
	protected EList symptoms = null;

	/**
	 * The cached value of the '{@link #getExtendedProperties() <em>Extended Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtendedProperties()
	 * @generated
	 * @ordered
	 */
	protected EList extendedProperties = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CBEDefaultEventImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return CBEPackage.eINSTANCE.getCBEDefaultEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnalyzed()
	{
		return analyzed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnalyzed(boolean newAnalyzed)
	{
		boolean oldAnalyzed = analyzed;
		analyzed = newAnalyzed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_DEFAULT_EVENT__ANALYZED, oldAnalyzed, analyzed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getExtensionName()
	{
		return extensionName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtensionName(String newExtensionName)
	{
		String oldExtensionName = extensionName;
		extensionName = newExtensionName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_DEFAULT_EVENT__EXTENSION_NAME, oldExtensionName, extensionName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSymptoms()
	{
		if (symptoms == null) {
			symptoms = new EObjectResolvingEList(SDBSymptom.class, this, CBEPackage.CBE_DEFAULT_EVENT__SYMPTOMS);
		}
		return symptoms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getExtendedProperties()
	{
		if (extendedProperties == null) {
			extendedProperties = new EObjectContainmentEList(CBEDefaultElement.class, this, CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES);
		}
		return extendedProperties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CBEPackage.CBE_DEFAULT_EVENT__AGENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
					return eBasicSetContainer(null, CBEPackage.CBE_DEFAULT_EVENT__AGENT, msgs);
				case CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES:
					return ((InternalEList)getExtendedProperties()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS, TRCAgent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
				return getAgent();
			case CBEPackage.CBE_DEFAULT_EVENT__ANALYZED:
				return isAnalyzed() ? Boolean.TRUE : Boolean.FALSE;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENSION_NAME:
				return getExtensionName();
			case CBEPackage.CBE_DEFAULT_EVENT__SYMPTOMS:
				return getSymptoms();
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES:
				return getExtendedProperties();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__ANALYZED:
				setAnalyzed(((Boolean)newValue).booleanValue());
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENSION_NAME:
				setExtensionName((String)newValue);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__SYMPTOMS:
				getSymptoms().clear();
				getSymptoms().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES:
				getExtendedProperties().clear();
				getExtendedProperties().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
				setAgent((TRCAgent)null);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__ANALYZED:
				setAnalyzed(ANALYZED_EDEFAULT);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENSION_NAME:
				setExtensionName(EXTENSION_NAME_EDEFAULT);
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__SYMPTOMS:
				getSymptoms().clear();
				return;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES:
				getExtendedProperties().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_DEFAULT_EVENT__AGENT:
				return getAgent() != null;
			case CBEPackage.CBE_DEFAULT_EVENT__ANALYZED:
				return analyzed != ANALYZED_EDEFAULT;
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENSION_NAME:
				return EXTENSION_NAME_EDEFAULT == null ? extensionName != null : !EXTENSION_NAME_EDEFAULT.equals(extensionName);
			case CBEPackage.CBE_DEFAULT_EVENT__SYMPTOMS:
				return symptoms != null && !symptoms.isEmpty();
			case CBEPackage.CBE_DEFAULT_EVENT__EXTENDED_PROPERTIES:
				return extendedProperties != null && !extendedProperties.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (analyzed: ");
		result.append(analyzed);
		result.append(", extensionName: ");
		result.append(extensionName);
		result.append(')');
		return result.toString();
	}

} //CBEDefaultEventImpl
