/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.configuration.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.Configuration;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;

import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;

import org.eclipse.hyades.logging.adapter.model.internal.context.impl.ContextPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;

import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ConfigurationPackageImpl extends EPackageImpl implements ConfigurationPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextInstanceTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass configurationTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass configurationEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ConfigurationPackageImpl() {
		super(eNS_URI, ConfigurationFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ConfigurationPackage init() {
		if (isInited) return (ConfigurationPackage)EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI);

		// Obtain or create and register package.
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ConfigurationPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) : ExtractorPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) : ContextPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) : OutputterPackageImpl.eINSTANCE);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);

		// Step 1: create meta-model objects
		theConfigurationPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theExtractorPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theContextPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theOutputterPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();

		// Step 2: complete initialization
		theConfigurationPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theExtractorPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theContextPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theOutputterPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();

		return theConfigurationPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContextInstanceType() {
		return contextInstanceTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextInstanceType_ContinuousOperation() {
		return (EAttribute)contextInstanceTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextInstanceType_Description() {
		return (EAttribute)contextInstanceTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextInstanceType_MaximumIdleTime() {
		return (EAttribute)contextInstanceTypeEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextInstanceType_PauseInterval() {
		return (EAttribute)contextInstanceTypeEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextInstanceType_UniqueID() {
		return (EAttribute)contextInstanceTypeEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_Sensor() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_Extractor() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_Parser() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_ProcessUnit() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_Formatter() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextInstanceType_Outputter() {
		return (EReference)contextInstanceTypeEClass.getEReferences().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConfigurationType() {
		return configurationTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConfigurationType_Description() {
		return (EAttribute)configurationTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConfigurationType_UniqueID() {
		return (EAttribute)configurationTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConfigurationType_ContextInstance() {
		return (EReference)configurationTypeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConfiguration() {
		return configurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationFactory getConfigurationFactory() {
		return (ConfigurationFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		contextInstanceTypeEClass = createEClass(CONTEXT_INSTANCE_TYPE);
		createEAttribute(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION);
		createEAttribute(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__DESCRIPTION);
		createEAttribute(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME);
		createEAttribute(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL);
		createEAttribute(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__UNIQUE_ID);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__SENSOR);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__EXTRACTOR);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__PARSER);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__PROCESS_UNIT);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__FORMATTER);
		createEReference(contextInstanceTypeEClass, CONTEXT_INSTANCE_TYPE__OUTPUTTER);

		configurationTypeEClass = createEClass(CONFIGURATION_TYPE);
		createEAttribute(configurationTypeEClass, CONFIGURATION_TYPE__DESCRIPTION);
		createEAttribute(configurationTypeEClass, CONFIGURATION_TYPE__UNIQUE_ID);
		createEReference(configurationTypeEClass, CONFIGURATION_TYPE__CONTEXT_INSTANCE);

		configurationEClass = createEClass(CONFIGURATION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)EPackage.Registry.INSTANCE.getEPackage(ExtractorPackage.eNS_URI);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)EPackage.Registry.INSTANCE.getEPackage(ParserPackage.eNS_URI);
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)EPackage.Registry.INSTANCE.getEPackage(FormatterPackage.eNS_URI);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)EPackage.Registry.INSTANCE.getEPackage(OutputterPackage.eNS_URI);

		// Add supertypes to classes
		configurationEClass.getESuperTypes().add(this.getConfigurationType());

		// Initialize classes and features; add operations and parameters
		initEClass(contextInstanceTypeEClass, ContextInstanceType.class, "ContextInstanceType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getContextInstanceType_ContinuousOperation(), ecorePackage.getEBoolean(), "continuousOperation", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextInstanceType_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextInstanceType_MaximumIdleTime(), ecorePackage.getEString(), "maximumIdleTime", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextInstanceType_PauseInterval(), ecorePackage.getEString(), "pauseInterval", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextInstanceType_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getContextInstanceType_Sensor(), theSensorPackage.getSensorConfigType(), null, "sensor", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getContextInstanceType_Extractor(), theExtractorPackage.getExtractorType(), null, "extractor", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getContextInstanceType_Parser(), theParserPackage.getParserConfigType(), null, "parser", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getContextInstanceType_ProcessUnit(), theUnitPackage.getProcessUnitType(), null, "processUnit", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getContextInstanceType_Formatter(), theFormatterPackage.getFormatterType(), null, "formatter", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getContextInstanceType_Outputter(), theOutputterPackage.getOutputterConfigType(), null, "outputter", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(configurationTypeEClass, ConfigurationType.class, "ConfigurationType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getConfigurationType_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getConfigurationType_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getConfigurationType_ContextInstance(), this.getContextInstanceType(), null, "contextInstance", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(configurationEClass, Configuration.class, "Configuration", !IS_ABSTRACT, !IS_INTERFACE);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore
		createXSD2EcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXSD2EcoreAnnotations() {
		String source = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "representation", "schema",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (contextInstanceTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "ContextInstanceType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_Sensor(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Sensor",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_Extractor(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Extractor",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_Parser(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Parser",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_ProcessUnit(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "ProcessUnit",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_Formatter(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Formatter",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_Outputter(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Outputter",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getContextInstanceType_ContinuousOperation(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "continuousOperation",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextInstanceType_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextInstanceType_MaximumIdleTime(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "maximumIdleTime",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextInstanceType_PauseInterval(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "pauseInterval",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextInstanceType_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (configurationTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "ConfigurationType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getConfigurationType_ContextInstance(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "ContextInstance",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });		
		addAnnotation
		  (getConfigurationType_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getConfigurationType_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (configurationEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Configuration",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/ComponentConfiguration.xsd"
		   });
	}
} //ConfigurationPackageImpl
