/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.outputter;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getUniqueID <em>Unique ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getSingleFileOutputterType <em>Single File Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getStandardOutOutputterType <em>Standard Out Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getLoggingAgentOutputterType <em>Logging Agent Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getNotificationOutputterType <em>Notification Outputter Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType()
 * @model 
 * @generated
 */
public interface OutputterConfigType extends EObject {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_Description()
	 * @model 
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #setType(OutputterType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_Type()
	 * @model unsettable="true" required="true"
	 * @generated
	 */
	OutputterType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #getType()
	 * @generated
	 */
	void setType(OutputterType value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetType()
	 * @see #getType()
	 * @see #setType(OutputterType)
	 * @generated
	 */
	void unsetType();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getType <em>Type</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Type</em>' attribute is set.
	 * @see #unsetType()
	 * @see #getType()
	 * @see #setType(OutputterType)
	 * @generated
	 */
	boolean isSetType();

	/**
	 * Returns the value of the '<em><b>Unique ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Unique ID</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Unique ID</em>' attribute.
	 * @see #setUniqueID(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_UniqueID()
	 * @model required="true"
	 * @generated
	 */
	String getUniqueID();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getUniqueID <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unique ID</em>' attribute.
	 * @see #getUniqueID()
	 * @generated
	 */
	void setUniqueID(String value);

	/**
	 * Returns the value of the '<em><b>Single File Outputter Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Single File Outputter Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Single File Outputter Type</em>' containment reference.
	 * @see #setSingleFileOutputterType(SingleFileOutputterType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_SingleFileOutputterType()
	 * @model containment="true"
	 * @generated
	 */
	SingleFileOutputterType getSingleFileOutputterType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getSingleFileOutputterType <em>Single File Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Single File Outputter Type</em>' containment reference.
	 * @see #getSingleFileOutputterType()
	 * @generated
	 */
	void setSingleFileOutputterType(SingleFileOutputterType value);

	/**
	 * Returns the value of the '<em><b>Standard Out Outputter Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Standard Out Outputter Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Standard Out Outputter Type</em>' containment reference.
	 * @see #setStandardOutOutputterType(StandardOutOutputterType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_StandardOutOutputterType()
	 * @model containment="true"
	 * @generated
	 */
	StandardOutOutputterType getStandardOutOutputterType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getStandardOutOutputterType <em>Standard Out Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Standard Out Outputter Type</em>' containment reference.
	 * @see #getStandardOutOutputterType()
	 * @generated
	 */
	void setStandardOutOutputterType(StandardOutOutputterType value);

	/**
	 * Returns the value of the '<em><b>Logging Agent Outputter Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Logging Agent Outputter Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Logging Agent Outputter Type</em>' containment reference.
	 * @see #setLoggingAgentOutputterType(LoggingAgentOutputterType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_LoggingAgentOutputterType()
	 * @model containment="true"
	 * @generated
	 */
	LoggingAgentOutputterType getLoggingAgentOutputterType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getLoggingAgentOutputterType <em>Logging Agent Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Logging Agent Outputter Type</em>' containment reference.
	 * @see #getLoggingAgentOutputterType()
	 * @generated
	 */
	void setLoggingAgentOutputterType(LoggingAgentOutputterType value);

	/**
	 * Returns the value of the '<em><b>Notification Outputter Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Notification Outputter Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Notification Outputter Type</em>' containment reference.
	 * @see #setNotificationOutputterType(NotificationOutputterType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#getOutputterConfigType_NotificationOutputterType()
	 * @model containment="true"
	 * @generated
	 */
	NotificationOutputterType getNotificationOutputterType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType#getNotificationOutputterType <em>Notification Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Notification Outputter Type</em>' containment reference.
	 * @see #getNotificationOutputterType()
	 * @generated
	 */
	void setNotificationOutputterType(NotificationOutputterType value);

} // OutputterConfigType
