/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.outputter.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ConfigurationPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;

import org.eclipse.hyades.logging.adapter.model.internal.context.impl.ContextPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterType;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;

import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterPackageImpl extends EPackageImpl implements OutputterPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass singleFileOutputterTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass standardOutOutputterTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass loggingAgentOutputterTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass notificationOutputterTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass outputterConfigTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum outputterTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private OutputterPackageImpl() {
		super(eNS_URI, OutputterFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static OutputterPackage init() {
		if (isInited) return (OutputterPackage)EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI);

		// Obtain or create and register package.
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new OutputterPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) : ExtractorPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) : ContextPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) : ConfigurationPackageImpl.eINSTANCE);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);

		// Step 1: create meta-model objects
		theOutputterPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theExtractorPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theContextPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theConfigurationPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();

		// Step 2: complete initialization
		theOutputterPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theExtractorPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theContextPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theConfigurationPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();

		return theOutputterPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSingleFileOutputterType() {
		return singleFileOutputterTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSingleFileOutputterType_Directory() {
		return (EAttribute)singleFileOutputterTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSingleFileOutputterType_FileName() {
		return (EAttribute)singleFileOutputterTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStandardOutOutputterType() {
		return standardOutOutputterTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLoggingAgentOutputterType() {
		return loggingAgentOutputterTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLoggingAgentOutputterType_AgentName() {
		return (EAttribute)loggingAgentOutputterTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLoggingAgentOutputterType_WaitUntilLoggingTime() {
		return (EAttribute)loggingAgentOutputterTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNotificationOutputterType() {
		return notificationOutputterTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNotificationOutputterType_ResourceURL() {
		return (EAttribute)notificationOutputterTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOutputterConfigType() {
		return outputterConfigTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOutputterConfigType_Description() {
		return (EAttribute)outputterConfigTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOutputterConfigType_Type() {
		return (EAttribute)outputterConfigTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOutputterConfigType_UniqueID() {
		return (EAttribute)outputterConfigTypeEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOutputterConfigType_SingleFileOutputterType() {
		return (EReference)outputterConfigTypeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOutputterConfigType_StandardOutOutputterType() {
		return (EReference)outputterConfigTypeEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOutputterConfigType_LoggingAgentOutputterType() {
		return (EReference)outputterConfigTypeEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOutputterConfigType_NotificationOutputterType() {
		return (EReference)outputterConfigTypeEClass.getEReferences().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getOutputterType() {
		return outputterTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterFactory getOutputterFactory() {
		return (OutputterFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		singleFileOutputterTypeEClass = createEClass(SINGLE_FILE_OUTPUTTER_TYPE);
		createEAttribute(singleFileOutputterTypeEClass, SINGLE_FILE_OUTPUTTER_TYPE__DIRECTORY);
		createEAttribute(singleFileOutputterTypeEClass, SINGLE_FILE_OUTPUTTER_TYPE__FILE_NAME);

		standardOutOutputterTypeEClass = createEClass(STANDARD_OUT_OUTPUTTER_TYPE);

		loggingAgentOutputterTypeEClass = createEClass(LOGGING_AGENT_OUTPUTTER_TYPE);
		createEAttribute(loggingAgentOutputterTypeEClass, LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME);
		createEAttribute(loggingAgentOutputterTypeEClass, LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME);

		notificationOutputterTypeEClass = createEClass(NOTIFICATION_OUTPUTTER_TYPE);
		createEAttribute(notificationOutputterTypeEClass, NOTIFICATION_OUTPUTTER_TYPE__RESOURCE_URL);

		outputterConfigTypeEClass = createEClass(OUTPUTTER_CONFIG_TYPE);
		createEAttribute(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__DESCRIPTION);
		createEAttribute(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__TYPE);
		createEAttribute(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__UNIQUE_ID);
		createEReference(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE);
		createEReference(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE);
		createEReference(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE);
		createEReference(outputterConfigTypeEClass, OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE);

		// Create enums
		outputterTypeEEnum = createEEnum(OUTPUTTER_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(singleFileOutputterTypeEClass, SingleFileOutputterType.class, "SingleFileOutputterType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getSingleFileOutputterType_Directory(), ecorePackage.getEString(), "directory", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getSingleFileOutputterType_FileName(), ecorePackage.getEString(), "fileName", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(standardOutOutputterTypeEClass, StandardOutOutputterType.class, "StandardOutOutputterType", !IS_ABSTRACT, !IS_INTERFACE);

		initEClass(loggingAgentOutputterTypeEClass, LoggingAgentOutputterType.class, "LoggingAgentOutputterType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getLoggingAgentOutputterType_AgentName(), ecorePackage.getEString(), "agentName", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getLoggingAgentOutputterType_WaitUntilLoggingTime(), ecorePackage.getEString(), "waitUntilLoggingTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(notificationOutputterTypeEClass, NotificationOutputterType.class, "NotificationOutputterType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getNotificationOutputterType_ResourceURL(), ecorePackage.getEString(), "resourceURL", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(outputterConfigTypeEClass, OutputterConfigType.class, "OutputterConfigType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getOutputterConfigType_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getOutputterConfigType_Type(), this.getOutputterType(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getOutputterConfigType_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getOutputterConfigType_SingleFileOutputterType(), this.getSingleFileOutputterType(), null, "singleFileOutputterType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getOutputterConfigType_StandardOutOutputterType(), this.getStandardOutOutputterType(), null, "standardOutOutputterType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getOutputterConfigType_LoggingAgentOutputterType(), this.getLoggingAgentOutputterType(), null, "loggingAgentOutputterType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getOutputterConfigType_NotificationOutputterType(), this.getNotificationOutputterType(), null, "notificationOutputterType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		// Initialize enums and add enum literals
		initEEnum(outputterTypeEEnum, OutputterType.class, "OutputterType");
		addEEnumLiteral(outputterTypeEEnum, OutputterType.STANDARD_OUT_OUTPUTTER_LITERAL);
		addEEnumLiteral(outputterTypeEEnum, OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL);
		addEEnumLiteral(outputterTypeEEnum, OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);
		addEEnumLiteral(outputterTypeEEnum, OutputterType.NOTIFICATION_OUTPUTTER_LITERAL);
		addEEnumLiteral(outputterTypeEEnum, OutputterType.UNDECLARED_LITERAL);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore
		createXSD2EcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXSD2EcoreAnnotations() {
		String source = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "representation", "schema",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (singleFileOutputterTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "SingleFileOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getSingleFileOutputterType_Directory(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "directory",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getSingleFileOutputterType_FileName(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "fileName",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (standardOutOutputterTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "StandardOutOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (loggingAgentOutputterTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "LoggingAgentOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getLoggingAgentOutputterType_AgentName(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "agentName",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getLoggingAgentOutputterType_WaitUntilLoggingTime(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "waitUntilLoggingTime",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (notificationOutputterTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "NotificationOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getNotificationOutputterType_ResourceURL(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "resourceURL",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (outputterTypeEEnum, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "OutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (outputterConfigTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "OutputterConfigType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getOutputterConfigType_SingleFileOutputterType(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "SingleFileOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getOutputterConfigType_StandardOutOutputterType(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "StandardOutOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getOutputterConfigType_LoggingAgentOutputterType(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "LoggingAgentOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getOutputterConfigType_NotificationOutputterType(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "NotificationOutputterType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Outputter.xsd"
		   });		
		addAnnotation
		  (getOutputterConfigType_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getOutputterConfigType_Type(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "type",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getOutputterConfigType_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });
	}
} //OutputterPackageImpl
