/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.parser;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rule Element Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getIndex <em>Index</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getRuleElement <em>Rule Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getRuleAttribute <em>Rule Attribute</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType()
 * @model 
 * @generated
 */
public interface RuleElementType extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType_Id()
	 * @model 
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Index</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Index</em>' attribute.
	 * @see #setIndex(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType_Index()
	 * @model 
	 * @generated
	 */
	String getIndex();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getIndex <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Index</em>' attribute.
	 * @see #getIndex()
	 * @generated
	 */
	void setIndex(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType_Name()
	 * @model required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Rule Element</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rule Element</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rule Element</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType_RuleElement()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType" containment="true"
	 * @generated
	 */
	EList getRuleElement();

	/**
	 * Returns the value of the '<em><b>Rule Attribute</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rule Attribute</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rule Attribute</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleElementType_RuleAttribute()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType" containment="true"
	 * @generated
	 */
	EList getRuleAttribute();

} // RuleElementType
