/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.sensor.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SensorFactoryImpl extends EFactoryImpl implements SensorFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case SensorPackage.SENSOR_PROPERTY_TYPE: return createSensorPropertyType();
			case SensorPackage.SENSOR_BASE_TYPE: return createSensorBaseType();
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE: return createSingleFileSensorType();
			case SensorPackage.ADAPTER_CBE_SENSOR_TYPE: return createAdapterCBESensorType();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE: return createStaticParserSensorType();
			case SensorPackage.SENSOR_CONFIG_TYPE: return createSensorConfigType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case SensorPackage.SENSOR_TYPE:
				return SensorType.get(initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case SensorPackage.SENSOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorPropertyType createSensorPropertyType() {
		SensorPropertyTypeImpl sensorPropertyType = new SensorPropertyTypeImpl();
		return sensorPropertyType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorBaseType createSensorBaseType() {
		SensorBaseTypeImpl sensorBaseType = new SensorBaseTypeImpl();
		return sensorBaseType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileSensorType createSingleFileSensorType() {
		SingleFileSensorTypeImpl singleFileSensorType = new SingleFileSensorTypeImpl();
		return singleFileSensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AdapterCBESensorType createAdapterCBESensorType() {
		AdapterCBESensorTypeImpl adapterCBESensorType = new AdapterCBESensorTypeImpl();
		return adapterCBESensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticParserSensorType createStaticParserSensorType() {
		StaticParserSensorTypeImpl staticParserSensorType = new StaticParserSensorTypeImpl();
		return staticParserSensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorConfigType createSensorConfigType() {
		SensorConfigTypeImpl sensorConfigType = new SensorConfigTypeImpl();
		return sensorConfigType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorPackage getSensorPackage() {
		return (SensorPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SensorPackage getPackage() {
		return SensorPackage.eINSTANCE;
	}

} //SensorFactoryImpl
