/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleDescriptor;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLSampleDescriptorLoader extends XMLCounterDescriptorLoader {
	protected static final String updateFrequency = "updateFrequency";
	protected double fUpdateFrequency;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case StatisticalConstants.updateFrequency_int :
				 fUpdateFrequency = Double.parseDouble(value);
				break;
			default :
				super.addAttribute(name, value);
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLCounterDescriptorLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		SDSampleDescriptor descriptor = (SDSampleDescriptor) LookupServiceExtensions.getInstance().locate(context, SDDescriptor.class, id);
		if (descriptor == null) {
			descriptor = StatisticalFactory.eINSTANCE.createSDSampleDescriptor();
			descriptor.setId(fId);
			LoadersUtils.getOrCreateAgent(context).getDescriptor().add(descriptor);
		}
		updateAttributes(descriptor);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader#updateAttributes(org.eclipse.hyades.model.statistical.SDDescriptor)
	 */
	protected void updateAttributes(SDSampleDescriptor descriptor) {
		super.updateAttributes(descriptor);
		descriptor.setUpdateFrequencey(fUpdateFrequency);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.statistical.XMLCounterDescriptorLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fUpdateFrequency=0;
	}
}
