/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Snapshot Observation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl#getValidityMask <em>Validity Mask</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl#getMemberDescriptor <em>Member Descriptor</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl#getWindow <em>Window</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SDSnapshotObservationImpl extends EObjectImpl implements SDSnapshotObservation {
	/**
	 * The cached value of the '{@link #getValidityMask() <em>Validity Mask</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValidityMask()
	 * @generated
	 * @ordered
	 */
	protected EList validityMask = null;

	/**
	 * The cached value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected EList creationTime = null;

	/**
	 * The cached value of the '{@link #getMemberDescriptor() <em>Member Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMemberDescriptor()
	 * @generated
	 * @ordered
	 */
	protected SDMemberDescriptor memberDescriptor = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDSnapshotObservationImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return StatisticalPackage.eINSTANCE.getSDSnapshotObservation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getValidityMask()
	{
		if (validityMask == null) {
			validityMask = new EDataTypeEList(Byte.class, this, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK);
		}
		return validityMask;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getCreationTime()
	{
		if (creationTime == null) {
			creationTime = new EDataTypeEList(Double.class, this, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__CREATION_TIME);
		}
		return creationTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDMemberDescriptor getMemberDescriptor()
	{
		if (memberDescriptor != null && memberDescriptor.eIsProxy()) {
			SDMemberDescriptor oldMemberDescriptor = memberDescriptor;
			memberDescriptor = (SDMemberDescriptor)EcoreUtil.resolve(memberDescriptor, this);
			if (memberDescriptor != oldMemberDescriptor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR, oldMemberDescriptor, memberDescriptor));
			}
		}
		return memberDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDMemberDescriptor basicGetMemberDescriptor()
	{
		return memberDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMemberDescriptor(SDMemberDescriptor newMemberDescriptor, NotificationChain msgs)
	{
		SDMemberDescriptor oldMemberDescriptor = memberDescriptor;
		memberDescriptor = newMemberDescriptor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR, oldMemberDescriptor, newMemberDescriptor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMemberDescriptor(SDMemberDescriptor newMemberDescriptor)
	{
		if (newMemberDescriptor != memberDescriptor) {
			NotificationChain msgs = null;
			if (memberDescriptor != null)
				msgs = ((InternalEObject)memberDescriptor).eInverseRemove(this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, SDMemberDescriptor.class, msgs);
			if (newMemberDescriptor != null)
				msgs = ((InternalEObject)newMemberDescriptor).eInverseAdd(this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, SDMemberDescriptor.class, msgs);
			msgs = basicSetMemberDescriptor(newMemberDescriptor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR, newMemberDescriptor, newMemberDescriptor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDSampleWindow getWindow()
	{
		if (eContainerFeatureID != StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW) return null;
		return (SDSampleWindow)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWindow(SDSampleWindow newWindow)
	{
		if (newWindow != eContainer || (eContainerFeatureID != StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW && newWindow != null)) {
			if (EcoreUtil.isAncestor(this, newWindow))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newWindow != null)
				msgs = ((InternalEObject)newWindow).eInverseAdd(this, StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS, SDSampleWindow.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newWindow, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW, newWindow, newWindow));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
					if (memberDescriptor != null)
						msgs = ((InternalEObject)memberDescriptor).eInverseRemove(this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, SDMemberDescriptor.class, msgs);
					return basicSetMemberDescriptor((SDMemberDescriptor)otherEnd, msgs);
				case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
					return basicSetMemberDescriptor(null, msgs);
				case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
					return eBasicSetContainer(null, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
					return ((InternalEObject)eContainer).eInverseRemove(this, StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS, SDSampleWindow.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK:
				return getValidityMask();
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__CREATION_TIME:
				return getCreationTime();
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
				if (resolve) return getMemberDescriptor();
				return basicGetMemberDescriptor();
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
				return getWindow();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK:
				getValidityMask().clear();
				getValidityMask().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__CREATION_TIME:
				getCreationTime().clear();
				getCreationTime().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)newValue);
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
				setWindow((SDSampleWindow)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK:
				getValidityMask().clear();
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__CREATION_TIME:
				getCreationTime().clear();
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)null);
				return;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
				setWindow((SDSampleWindow)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK:
				return validityMask != null && !validityMask.isEmpty();
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__CREATION_TIME:
				return creationTime != null && !creationTime.isEmpty();
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR:
				return memberDescriptor != null;
			case StatisticalPackage.SD_SNAPSHOT_OBSERVATION__WINDOW:
				return getWindow() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (validityMask: ");
		result.append(validityMask);
		result.append(", creationTime: ");
		result.append(creationTime);
		result.append(')');
		return result.toString();
	}

} //SDSnapshotObservationImpl
