/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/*
 * Created on Nov 6, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NewObjectAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NewActionGroup extends NavigatorActionGroup {

	private NewObjectAction newSymptomDBAction;
	private NewObjectAction newCorrelationAction;

	/**
	 * Constructor for CreateGroupAction
	 * @param testNavigator
	 */
	public NewActionGroup(Navigator navigator)
	{
		super(navigator);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions() {

		newSymptomDBAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newSymptomDBAction.setText(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD"));
		newSymptomDBAction.setToolTipText(newSymptomDBAction.getText());
		newSymptomDBAction.setImageDescriptor(getImageDescriptor("elcl16/symptomdb_nav.gif"));
		newSymptomDBAction.setHoverImageDescriptor(getImageDescriptor("clcl16/symptomdb_nav.gif"));
		newSymptomDBAction.setWizardCategory("org.eclipse.hyades.trace_log.newWizard");
		
		newCorrelationAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newCorrelationAction.setText(LogUIPlugin.getResourceString("STR_NEW_CORR_MENUITEM"));
		newCorrelationAction.setToolTipText(LogUIPlugin.getResourceString("STR_NEW_CORR_TOOLTIP"));
		newCorrelationAction.setImageDescriptor(getImageDescriptor("elcl16/correlation_nav.gif"));
		newCorrelationAction.setHoverImageDescriptor(getImageDescriptor("clcl16/correlation_nav.gif"));		
		newCorrelationAction.setWizardCategory("org.eclipse.hyades.trace_log.newWizard");

	}
	

	/**
	 * Returns the image descriptor from the eclipse UI plugin with the given relative 
	 * path.
	 * @return ImageDescriptor;
	 */
	protected ImageDescriptor getImageDescriptor(String relativePath)
	{
		String iconPath = "icons/full/";
		try
		{
			AbstractUIPlugin plugin = (AbstractUIPlugin) org.eclipse.core.runtime.Platform.getPlugin(LogUIPlugin.getPluginId());
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath + relativePath);
			return ImageDescriptor.createFromURL(url);
		}
		catch(MalformedURLException e)
		{
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		IStructuredSelection structuredSelection = (IStructuredSelection)getContext().getSelection();

        
		if(getNavigator().isShowingFolders())
		{
			if(!hasLogicalFolder(structuredSelection))
			{
				MenuManager newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
				menu.add(newMenu);

				new NewWizardMenu(newMenu, getNavigator().getSite().getWorkbenchWindow(), false);

				newMenu.insert(0, new ActionContributionItem(newSymptomDBAction));
				newMenu.insert(1, new Separator());
			}
		}
		else
		{
			MenuManager newMenu = null;
			if(structuredSelection.size()>0){
				boolean selAgents = true;
				for (Iterator iter = structuredSelection.iterator(); iter.hasNext();) {
					if(!(iter.next() instanceof TRCAgentProxy)){
						selAgents = false;
						break;
					}					
				}
				if(selAgents){
					newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
					menu.add(newMenu);							
					newMenu.add(newCorrelationAction);					
				}
			}

			if(structuredSelection.size() == 1)
			{
				Object selection = structuredSelection.getFirstElement();
				if(selection instanceof LogicalFolder)
				{
					LogicalFolder logicalFolder = (LogicalFolder)selection;
					if(logicalFolder.getParent() == null)
					{						

						String name = logicalFolder.getName();
						if(name.equals(LogUIPlugin.getResourceString("LOG_NAV_SDFLD"))){
							newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
							menu.add(newMenu);
							newMenu.add(newSymptomDBAction);
						}
							
						if(name.equals(LogUIPlugin.getResourceString("LOG_NAV_CORRFLD"))){	
							newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
							menu.add(newMenu);							
							newMenu.add(newCorrelationAction);
						}
					}
				}
			}
		}
	}
	
		/**
		 * Returns <code>true</code> is there is one logical folder in the 
		 * given selection.
		 * @param structuredSelection
		 * @return boolean
		 */
		protected boolean hasLogicalFolder(IStructuredSelection structuredSelection)
		{
			for (Iterator i = structuredSelection.iterator(); i.hasNext();)
			{
				if(i.next() instanceof LogicalFolder)
					return true;
			}
		
			return false;
		}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.actions.ActionGroup#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public void fillActionBars(IActionBars actionBars) {		
		
		IToolBarManager toolbar = actionBars.getToolBarManager();		
		toolbar.add(new Separator());
		toolbar.add(newCorrelationAction);		
		
	}

}
