/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.lang.reflect.*;
import java.text.*;
import java.util.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
//import org.eclipse.hyades.loaders.hierarchy.LoadersUtils;
import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.models.cbe.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.viewers.*;

/**
 * This class is used for displaying attributes of Common Base Event Model objects
 * i.e properties of log records
 */
public class RecordPaneContentProvider
	implements IStructuredContentProvider {

    private HashMap _methods = new HashMap();		

	public void dispose() {
		_methods.clear();
	}

	public Object getElementAt(Object rowElement, int index) {
		if (rowElement instanceof CBEExtendedDataElement) {

			switch (index) {
				case 0 :
					return ((CBEExtendedDataElement) rowElement).getName();
				case 1 :
					if(((CBEExtendedDataElement) rowElement).getValues().size() > 0)				
						return ((CBEExtendedDataElement) rowElement).getValues().get(0).toString();
			}
		}
		return "unknown row element";
	}
	// ******* IStructuredContentProvider method implementations *******

	public Object[] getElements(Object element) {


		ArrayList elements = new ArrayList();

		if (element instanceof EObject && ((EObject)element).eClass().getEPackage()==CBEPackage.eINSTANCE){
			
			elements.addAll(getEObjectAttributes((EObject)element));
		}
// TODO add support for new correlation mode
//		else
//		if(element instanceof TerminalNode && ((TerminalNode) element).getParent() instanceof CBEAssociationEngine){
//			elements.addAll(getEObjectAttributes(((TerminalNode) element).getParent()));	
//		}
		return elements.toArray();

	}

	/**
	 * Method getEObjectAttributes.
	 * @param object
	 * @return List
	 */
	private List getEObjectAttributes(EObject object) {
		List list = new ArrayList();
		
		EClass eClass = ((EObject)object).eClass();
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		List columns =
			ColumnData.createColumnDataFromString(
				store.getString(LogUIConstants.PD_FILTER_OPTIONS));
		List visibleColumns = new ArrayList();
		

		String visibleCol = "";
		EList attributes = eClass.getEAllAttributes();
		for (int idx = 0; idx < columns.size(); idx++)
		{
			ColumnData data = (ColumnData) columns.get(idx);
			if (data.visible()) {
				
				visibleCol = data.name().toLowerCase();
				EAttribute attribute = findAttributeInList(visibleCol, attributes);
				if(attribute!=null){
					try {
						Object value = object.eGet(attribute);
						if(attribute.getName().equals("creationTime")){
							value = formatCreationTime(value, object.getClass(), object);	
						}

						if(attribute.isMany() && attribute.getEType().getInstanceClass() == String.class){
							int index = 0;
							for (Iterator iter1 = ((EList)object.eGet(attribute)).iterator(); iter1.hasNext();) {
								RecordTableElement elem = new RecordTableElement(attribute.getName() + "["+ index++ +"]", (String)iter1.next());
								list.add(elem);		
							}

						}
						else
						{
							RecordTableElement elem = new RecordTableElement(attribute.getName(), value!=null ? value.toString():"");
							list.add(elem);		
						}
					} catch (Exception e) {
						//ignore attribute
					}

				}
				
			}
		}
				
		return list;
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	public boolean isDeleted(Object element) {

		return false;
	}
	private String getFirstLine(String input) {
		String firstLine = "";
		char charArray[] = input.toCharArray();
		int found = -1;

		for (int idx = 0; idx < charArray.length; idx++) {
			if ((charArray[idx] == '\r')
				|| (charArray[idx] == '\n')
				|| (charArray[idx] == '\f')) {
				found = idx;
				break;
			}
		}

		if ((found > -1) && (found != 0)) {
			firstLine = input.substring(0, found);
		} else {
			firstLine = input;
		}

		return firstLine;
	}
	
	private SimpleDateFormat getDateTimeFormat(){
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		String dateFormat = store.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE);

		boolean valid = false;
		for (int i = 0; i < LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST.length; i++)
			if (dateFormat.equals(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[i])) {
				valid = true;
				break;
			}

		if (!valid)
			dateFormat = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;

		String timeFormat = store.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME);

		valid = false;
		for (int i = 0; i < LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST.length; i++)
			if (timeFormat.equals(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[i])) {
				valid = true;
				break;
			}

		if (!valid)
			timeFormat = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;

		if (timeFormat.startsWith("h"))
			timeFormat = timeFormat + " a";


		java.text.SimpleDateFormat formatter =
				new java.text.SimpleDateFormat(dateFormat + " " + timeFormat);

		return formatter;

	}
	
	

	/**
	 * Method formatCreationTime.
	 * @param l
	 * @param element
	 * @return Object
	 */
	private Object formatCreationTime(Object l, Class clsName, Object element) {

		String res="0";
		CBECommonBaseEvent event = (CBECommonBaseEvent)element; 
		
		// if time is not specified, use "0"
		if (event.getCreationTime() != 0)
		{
			try {
				short value=0;
				try {
					Method method = getMethod(clsName, "getTimeZone");
					if (method != null) {
						value = ((Short)method.invoke(element, null)).shortValue();
					}
				} catch (Exception e1) {
				}
				
				double ct = CBEUtils.computeAdjustedCreationTime(event);
				Double l2 = new Double(ct);
				
				//SimpleDateFormat dateFormat = LoadersUtils.getPartialCIMDateFormat();
				SimpleDateFormat dateFormat = getDateTimeFormat();
				
				res = dateFormat.format(new Date(((Double)l2).longValue()/1000 + value*60*1000));
				String microseconds = ""+(((Double)l2).longValue() % 1000000);
				res = res + "."+"000000".substring(0,6-microseconds.length()) + microseconds;
				res = res + (value>0?"+00":"-00").substring(0,3-(""+Math.abs(value/60)).length())+Math.abs(value/60);
				res = res + ":00".substring(0,3-(""+Math.abs(value%60)).length())+Math.abs(value%60);
				
			} catch (Exception e) {
			}
		}
		
		return res;

	}

	private Method getMethod(Class cls, String name) throws Exception{

			Method method = (Method)_methods.get(cls.getName() + name);
			if(method == null)
			{			
			   method = cls.getMethod(name, null);
			   _methods.put(cls.getName() + name, method);			  
			}
			
			return method;
	
	}
	
	private EAttribute findAttributeInList(String name, EList attributeList){
		
		for(int i=0;i<attributeList.size();i++){			
			EAttribute attr = (EAttribute) attributeList.get(i);
			if(attr.getName().toLowerCase().equals(name))
				return attr;
		}
		return null;
	}
	
}