/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Nov 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NewCorrelationWizard extends Wizard implements INewWizard {

	private LogSelectionWizardPage selPage;
	private CorrelationSelectionWizardPage corrPage;
	private IStructuredSelection sel;
	private IWorkbench workbench;	
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		final CorrelationContainerProxy correlationContainerProxy = createCorrelationContainer();
		if(correlationContainerProxy!=null){
			
			try {
				IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
				if(page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
					IAdaptable element =
					ResourcesPlugin.getWorkspace().getRoot();
					if (element != null)
						page =
							workbench.showPerspective(
								PDPerspective.ID_TRACE_PERSPECTIVE,
								workbench.getActiveWorkbenchWindow(),
								element);
				}
				if(page!=null){					
					final IViewPart part = page.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
					if(part!=null){
										
						Display.getDefault().asyncExec(new Runnable()
						{
							public void run()
							{
								((LogNavigator)part).selectReveal(new StructuredSelection(correlationContainerProxy));
							}
						});						
					}
				}
			} catch (Exception e) {				
				e.printStackTrace();
			}
		}
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		store.setValue("corr_nr",store.getInt("corr_nr")+1);
		
		return true;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		sel = selection;
		this.workbench = workbench;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {


		setWindowTitle(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"));
		super.addPages();
		selPage = new LogSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), sel);
		addPage(selPage);
			
		corrPage = new CorrelationSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), getCorrelationExtensions());
		addPage(corrPage);		
	}
	
	private IExtension[] getCorrelationExtensions(){
		
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point =	registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");//$NON-NLS-1$
		IExtension[] extensions = null;
		if (point != null) {
			extensions = point.getExtensions();
		}
		return extensions;
	}
	
	private CorrelationContainerProxy createCorrelationContainer(){
		
		BasicEList recordListToCorrelate = new BasicEList();
		String correlationType = null;
		CorrelationContainerProxy correlationContainerProxy = null;
		ILogRecordCorrelationEngine recordCorrelator = null;
		IConfigurationElement correlation = corrPage.getCorrelation();
		List agentList = selPage.getLogFiles();
		IConfigurationElement[] filters_correlators = addNodes(correlation, recordListToCorrelate, agentList);
		for (int k = 0; k < filters_correlators.length; k++)
		{
			if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine"))
			{
				try 
				{
					recordCorrelator =(ILogRecordCorrelationEngine) filters_correlators[k].createExecutableExtension("class");							
					correlationType =correlation.getAttribute("name");
				}
				catch (Exception e)
				{
					//System.out.println("CoreException->Correlator");
				}
			}
		}
		if (recordCorrelator != null && agentList.size()>0)
		{
			correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)agentList.get(0),correlationType,selPage.getName());
			correlationContainerProxy.setName(selPage.getName());
			CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
			correlationEngine.setId(correlationType);
			correlationEngine.setType(correlation.getAttribute("log_types"));
			correlationEngine.setName(correlation.getAttribute("name"));
			correlationContainerProxy.setCorrelationEngine(correlationEngine);
			for (int i = 1; i < agentList.size(); i++) {
				if (agentList.get(i)!=null)
				correlationContainerProxy.getCorrelatedAgents().add(agentList.get(i));	
			}

			recordCorrelator.correlate(correlationContainerProxy,recordListToCorrelate);
		}
		return correlationContainerProxy;
	
	}
	
	private IConfigurationElement[] addNodes(IConfigurationElement correlation, BasicEList recordListToCorrelate, List agentList) {
		IConfigurationElement[] filters_correlators =correlation.getChildren();
		ILogRecordFilter logFilter = null;

		boolean notAdded = true;
		for (int i = 0; i < agentList.size(); i++) 
		{
			if (agentList.get(i) != null) 
			{
				for (int k = 0;k < filters_correlators.length;k++) 
				{
					if (filters_correlators[k].getName().equals("LogRecordFilter")&& ((TRCAgentProxy)agentList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type")))
					{
						try 
						{
							logFilter =(ILogRecordFilter) filters_correlators[k].createExecutableExtension("class");
							recordListToCorrelate.add(loadLog((TRCAgentProxy)agentList.get(i),logFilter));
							notAdded = false;
						} 
						catch (Exception e)
						{	
							recordListToCorrelate.add(loadLog((TRCAgentProxy)agentList.get(i), null));
							notAdded = false;
						}
					} 
					else if (((TRCAgentProxy)agentList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type"))) 
					{
						recordListToCorrelate.add(loadLog((TRCAgentProxy)agentList.get(i), null));
						notAdded = false;
					}
				}
				if (notAdded)
				{
					recordListToCorrelate.add(loadLog((TRCAgentProxy)agentList.get(i), null));
				}
			}
			notAdded = true;
		}
		return filters_correlators;
	}

	private RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter){
		 
		 RecordList recList=null;
		 if(logFilter!=null)
			recList = new RecordList(cbeEventFilter(logFilter.filter(agent.getAgent().getDefaultEvents())),agent.getName());
		 else
			recList = new RecordList(cbeEventFilter(agent.getAgent().getDefaultEvents()),agent.getName());
		 
		 return recList;
	}
	
	private EList cbeEventFilter(EList list)
	{
		
		EList filteredList = new BasicEList();
		Iterator it = list.iterator();
		while (it.hasNext()) {
			Object event = it.next();
			if (event instanceof CBECommonBaseEvent) {
				filteredList.add(event);
			}
		}
		return filteredList;		
	}
	
	

}
