/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.util.*;

import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.security.util.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class TraceProfileCollectionsUI
	implements SelectionListener, ModifyListener {
	private void addMonitorOption(Composite parent) {
		_monitoringGroup = new Composite(parent, SWT.NULL);
		GridData data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		_monitoringGroup.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		_monitoringGroup.setLayout(layout);
	
		_autoMonitoring = new Button(_monitoringGroup, SWT.CHECK);
		_autoMonitoring.setText(
			UIPlugin.getResourceString("AUTO_MONITORING_CHECKBOX"));
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_autoMonitoring,
			UIPlugin.getPluginId() + ".topp0010");
	
		_monitoringDesp = new Label(_monitoringGroup, SWT.NULL);
		_monitoringDesp.setText(
			UIPlugin.getResourceString("AUTO_MONITORING_LABEL"));
		data = new GridData();
		data.horizontalIndent = 20;
		_monitoringDesp.setLayoutData(data);
		_monitoringDesp.setVisible(false);
	}

	private Label _limitInvocLabel;
	private Label _limitTimeLabel;
	private Text _limitTime;
	private Text _limitInvocations;
	private Button _limitTimeBtn;
	private Button _limitInvocBtn;
	
	private Composite _monitoringGroup;
	private Button _autoMonitoring;
	private Label _monitoringDesp;
	
	private WizardPage _wizardPage;
	private PreferencePage _preferencePage;

	public TraceProfileCollectionsUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		data.heightHint = 300;
		data.widthHint = 400;

		result.setLayout(layout);
		result.setLayoutData(data);

		addLimitTraceGroup(result);

		addMonitorOption(result);
		_monitoringGroup.setVisible(false);

		return result;
	}

	private void addLimitTraceGroup(Composite parent) {
		Group grp = new Group(parent, SWT.NULL);
		GridData data = GridUtil.createHorizontalFill();
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		grp.setLayout(layout);
		grp.setLayoutData(data);
		grp.setText(UIPlugin.getResourceString("STR_LIMIT_DATA_AMOUNT"));

		_limitInvocBtn = new Button(grp, SWT.CHECK);
		_limitInvocBtn.setText(UIPlugin.getResourceString("STR_INV_LIMIT_OPTION"));
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_limitInvocBtn.setLayoutData(data);

		_limitInvocLabel = new Label(grp, SWT.NULL);
		_limitInvocLabel.setText(UIPlugin.getResourceString("STR_INV_LIMIT_NB"));
		data = new GridData();
		data.horizontalIndent = 20;
		_limitInvocLabel.setLayoutData(data);
		_limitInvocations = new Text(grp, SWT.BORDER);
		_limitInvocations.setLayoutData(GridUtil.createHorizontalFill());

		_limitTimeBtn = new Button(grp, SWT.CHECK);
		_limitTimeBtn.setText(UIPlugin.getResourceString("STR_TIME_LIMIT_OPTION"));
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_limitTimeBtn.setLayoutData(data);

		_limitTimeLabel = new Label(grp, SWT.NULL);
		_limitTimeLabel.setText(UIPlugin.getResourceString("STR_TIME_LIMIT_NB"));
		data = new GridData();
		data.horizontalIndent = 20;
		_limitTimeLabel.setLayoutData(data);
		_limitTime = new Text(grp, SWT.BORDER);
		_limitTime.setLayoutData(GridUtil.createHorizontalFill());

		_limitInvocBtn.addSelectionListener(this);
		_limitTimeBtn.addSelectionListener(this);

		_limitInvocations.addModifyListener(this);
		_limitTime.addModifyListener(this);
	}

	public void enable(boolean enable) {
		_limitInvocations.setEnabled(enable);
		_limitInvocBtn.setEnabled(enable);
		_limitInvocLabel.setEnabled(enable);
		_limitTime.setEnabled(enable);
		_limitTimeBtn.setEnabled(enable);
		_limitTimeLabel.setEnabled(enable);
	}

	public void enableButtons() {

		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		setLimitInvocations(
			store.getBoolean(TraceConstants.LIMIT_TRACE_INVOC_OPTION));
		setLimitTime(store.getBoolean(TraceConstants.LIMIT_TRACE_TIME_OPTION));
		setLimitInvocNb(store.getString(TraceConstants.LIMIT_INVOC_NB));
		setLimitTimeNb(store.getString(TraceConstants.LIMIT_TIME_NB));
		setAutoMonitoring(store.getBoolean(TraceConstants.PROF_AUTO_MONITOR));
		
	}

	public Vector getOptions() {
		Vector options = new Vector();

		//time,imvocations limited events
		if (getLimitInvocations()) {
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(Options.OPTION_BURST_MODE);
			entry.setType("SETOPTION");

			if (getLimitTime()) {
				entry.setValue(Options.OPTION_VALUE_SECONDSANDINVOCATIONS);

				AgentConfigurationEntry entry1 = new AgentConfigurationEntry();
				entry1.setName(Options.OPTION_BURST_SECONDS);
				entry1.setValue(String.valueOf(getLimitTimeNb()));
				entry1.setType("SETOPTION");

				options.addElement(entry1);
			} else {
				entry.setValue(Options.OPTION_VALUE_INVOCATIONS);
			}

			options.addElement(entry);

			AgentConfigurationEntry entry1 = new AgentConfigurationEntry();
			entry1.setName(Options.OPTION_BURST_INVOCATIONS);
			entry1.setValue(String.valueOf(getLimitInvocNb()));
			entry1.setType("SETOPTION");

			options.addElement(entry1);

		} else if (getLimitTime()) {
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(Options.OPTION_BURST_MODE);
			entry.setType("SETOPTION");
			entry.setValue(Options.OPTION_VALUE_SECONDS);

			options.addElement(entry);

			entry = new AgentConfigurationEntry();
			entry.setName(Options.OPTION_BURST_SECONDS);
			entry.setValue(String.valueOf(getLimitTimeNb()));
			entry.setType("SETOPTION");

			options.addElement(entry);
		}
		return options;
	}

	public void modifyText(ModifyEvent event)
	{   
		if (event.getSource()==_limitInvocations
			|| event.getSource() == _limitTime)
		{
			checkNumbersAndPrintErrorMsg();
		}
	}
	
	private boolean checkValidTextInput()
	{
		String tempText;		
		if (_limitInvocBtn.getSelection())
		{
			tempText = _limitInvocations.getText().trim();
			try {
				if (Integer.parseInt(tempText)<=0) return false;
			}
			catch(Exception exc)
			{
				return false;
			}
		}
		if (_limitTimeBtn.getSelection())
		{
			tempText = _limitTime.getText().trim();
			try {
				if (Integer.parseInt(tempText)<=0) return false;
			}
			catch(Exception exc)
			{
				return false;
			}			
		}
		return true;
	}

	public boolean getLimitInvocations() {
		return _limitInvocBtn.getSelection();
	}

	public int getLimitInvocNb() {
		String text = _limitInvocations.getText().trim();

		try {
			int value = Integer.parseInt(text);
			if (value>0) return value;
			else return  UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.LIMIT_INVOC_NB);
		} catch (Exception exc) {
			return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.LIMIT_INVOC_NB);
		}
	}

	public boolean getLimitTime() {
		return _limitTimeBtn.getSelection();
	}

	public int getLimitTimeNb() {
		String text = _limitTime.getText().trim();

		try {
			int value = Integer.parseInt(text);
			if (value>0) return value;
			else return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.LIMIT_TIME_NB);
		} catch (Exception exc) {
			return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.LIMIT_TIME_NB);
		}
	}

	public void setLimitInvocations(boolean setValue) {
		_limitInvocBtn.setSelection(setValue);

		if (!_limitInvocBtn.isEnabled())
			return;

		_limitInvocations.setEnabled(setValue);
		_limitInvocLabel.setEnabled(setValue);
	}

	public void setLimitInvocNb(String value) {
		_limitInvocations.setText(value);
	}

	public void setLimitTime(boolean setValue) {
		_limitTimeBtn.setSelection(setValue);

		if (!_limitTimeBtn.isEnabled())
			return;

		_limitTime.setEnabled(setValue);
		_limitTimeLabel.setEnabled(setValue);
	}

	public void setLimitTimeNb(String value) {
		_limitTime.setText(value);
	}

	public void widgetDefaultSelected(SelectionEvent event) {
	}

	public void widgetSelected(SelectionEvent event) {
		if (event.widget == _limitInvocBtn) {
			_limitInvocations.setEnabled(_limitInvocBtn.getSelection());
			_limitInvocLabel.setEnabled(_limitInvocBtn.getSelection());
		} else if (event.widget == _limitTimeBtn) {
			_limitTime.setEnabled(_limitTimeBtn.getSelection());
			_limitTimeLabel.setEnabled(_limitTimeBtn.getSelection());
		}
	}
	
	public void checkNumbersAndPrintErrorMsg()
	{
		if (_wizardPage!=null)
		{
			if (!checkValidTextInput())
			{
				_wizardPage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_COLLECTION_VALUE"));
				_wizardPage.setPageComplete(false);
			}
			else
			{
				_wizardPage.setErrorMessage(null);
				_wizardPage.setPageComplete(true);
			}
		}
		else if (_preferencePage!=null)
		{
			if (!checkValidTextInput())
			{
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_COLLECTION_VALUE"));
				_preferencePage.setValid(false);
			}
			else
			{
				_preferencePage.setErrorMessage(null);
				_preferencePage.setValid(true);
			}
		
		}
	}


	public void setWizardPage(WizardPage page) {
		_wizardPage = page;
	}

	public void setPreferencePage(PreferencePage page) {
		_preferencePage = page;
	}

	public void enableMonitoringSlectionGroup(boolean visible) {
		_monitoringGroup.setVisible(visible);
	}

	public void enableMonitoringDesp(boolean visible) {
		_monitoringDesp.setVisible(visible);
	}

	public boolean getAutoMonitoring() {
		return _autoMonitoring.getSelection();
	}

	public void setAutoMonitoring(boolean select) {
		_autoMonitoring.setSelection(select);
	}

	public void storeValues() {
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		store.setValue(TraceConstants.PROF_AUTO_MONITOR, getAutoMonitoring());
	}

}
