/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.wizard.*;

/*
* CONTEXT_ID dest0000 for destination folder page
*/

public class DestinationFolderPage  extends WizardPage 
							  implements ModifyListener,SelectionListener
{
	private TraceLocationUI _locationUI;
	private TraceFileUI _fileUI;
	private String location;
	private String monitor; 

public DestinationFolderPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("STR_DEST_MON_PAGE"));

	String desc = UIPlugin.getResourceString("STR_DEST_MON_DESC");
	setDescription(desc); 
	
  }
  
  public void createControl(Composite parent)
  {
	GridLayout layout;
	
	Composite btnGroup = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=0;       
	btnGroup.setLayout(layout);
	btnGroup.setLayoutData(GridUtil.createFill());

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(btnGroup);
	
	_fileUI = new TraceFileUI();
	_fileUI.createControl(btnGroup);
	
	_locationUI.getLocation().addModifyListener(this);
	_locationUI.getMonitor().addModifyListener(this);
	
	_fileUI.getExternalBox().addSelectionListener(this);
	_fileUI.getFileText().addModifyListener(this);

	setControl(btnGroup);

    if(!UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY))
    {
    	_fileUI.setVisible(false);
    }
    
	initializeValues();

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
	parent,
	UIPlugin.getPluginId()+".dest0000");
  }
  
  public String getProject()
  {
  	return location;
  }      
  
  public String getMonitor()
  {
  	return monitor;
  }
  
  public String getFile()
  {
  	return (_fileUI.getSelection()?_fileUI.getFile():"");
  }
  
  public boolean finish()  
  {
	  location = _locationUI.getLocation().getText().trim();
	  monitor = _locationUI.getMonitor().getText().trim();
	  
	  return true;
  }  
/**
 * Insert the method's description here.
 * Creation date: (8/16/2001 1:22:08 PM)
 * @return com.ibm.etools.pd.core.ui.TraceLocationUI
 */
public TraceLocationUI getLocation() {
	return _locationUI;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2001 2:08:00 PM)
 */
public void initializeValues()
{
	if(getWizard() instanceof RelaunchWizard)
	{
		((RelaunchWizard)getWizard()).initializeLocation();
	}
	
	location = (_locationUI.getLocation()).getText();
	monitor = (_locationUI.getMonitor()).getText();
	
}
private void checkPageComplete()
{
	setPageComplete(!_locationUI.getLocation().getText().trim().equals("")
		            && !_locationUI.getMonitor().getText().trim().equals("")
		            && (_fileUI.getSelection()? !_fileUI.getFile().equals(""):true));	
}
/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:51:52 PM)
 * @param event com.ibm.swt.events.ModifyEvent
 */
public void modifyText(ModifyEvent event)
{
	checkPageComplete();	
}

public void widgetDefaultSelected(SelectionEvent e)
{}

public void widgetSelected(SelectionEvent e)
{
    checkPageComplete();
}

}
