/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/*
* CONTEXT_ID rnwp0000 for relaunch wizard node page
*/

public class RelaunchNodeWizardPage extends WizardPage implements ModifyListener
{
  	protected TraceNodeUI _nodeUI;

  public RelaunchNodeWizardPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
	setDescription(UIPlugin.getResourceString("RELAUNCH_NODE_PROPERTIES_DESC"));
  }    
  
  public void createControl(Composite parent)
  {
	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = new GridData();
	gd.verticalAlignment   = GridData.FILL;
	gd.horizontalAlignment = GridData.FILL;
	gd.grabExcessHorizontalSpace = true;
	gd.widthHint = 500; 
	content.setLayoutData(gd);

	_nodeUI = new TraceNodeUI(false);
	_nodeUI.createControl(content);
	_nodeUI.setShowDelta(false);	
			
	//add listeners
	_nodeUI.getPortNumberUI().addModifyListener(this);   
		
	setControl(content);

	_nodeUI.setEnabled(false);
	
	populateData();
	
	setPageComplete(true);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
	UIPlugin.getPluginId()+".rnwp0000");
  }  

  public TraceNodeUI getNodeUI()
  {
  	return _nodeUI;
  }

  public boolean finish()
  {
	return(true);
  }  

public void modifyText(ModifyEvent event)
{
	setPageComplete(true);

	String port = _nodeUI.getPortNumberUI().getText().trim();
	
	if (event.widget == _nodeUI.getPortNumberUI())
	{
		try {
			int value = Integer.parseInt(port);
			if (value<0)
			{
				setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);  
			setPageComplete(true);
		} catch (NumberFormatException nfe) {
			setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));  
			setPageComplete(false);
		}
	}
}

/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{	
	TRCNode node = ((RelaunchWizard)getWizard()).getNode();

	if(node == null)
	  return;

	_nodeUI.getNodeNameUI().setText(node.getName());
	_nodeUI.getPortNumberUI().setText(String.valueOf(node.getPort()));
	if (node.getIpAddress() != null) 
		_nodeUI.getAddressUI().setText(node.getIpAddress());
			
}


}
