/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.*;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.hierarchy.TRCAgent;


public final class XMLagentDestroyLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String agentIdRef;
    private double time;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("agentIdRef")) {
            agentIdRef = value;
        } else if (name.equals("time")) {
            time = Double.valueOf(value).doubleValue();
        }
    }

    public void addYourselfInContext() {
    	if(agentIdRef!=null && time!=0)
    	{
			TRCAgent agent = LoadersUtils.locateAgent(agentIdRef,context.getAgent());
			if(agent!=null)
			{
				agent.setStopTime(time);
				agent.getAgentProxy().setStopTime(time);
			}
    	}
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        agentIdRef = null;
        time = 0;
    }
}
