/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import java.util.Iterator;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.*;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;


public class XMLprocessCreateLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String application_executable;
    private String name;
    private String nodeIdRef;
    private String processId;
    private TRCProcessProxy process;
    private int pid;

    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.models.loader.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
        if (name.equals("processId")) {
            processId = value;
        } else if (name.equals("nodeIdRef")) {
            nodeIdRef = value;
        } else if (name.equals("name")) {
            name = value;
        } else if (name.equals("pid")) {
            pid = Integer.valueOf(value).intValue();
        } else if (name.equals("application_executable")) {
            application_executable = value;
        }
    }

    public void addYourselfInContext() {

        TRCMonitor monitor = context.getMonitor();

        if (monitor == null) {
            return;
        }

        TRCNode node = context.getNode();

        /* If we don't have a node association, find one based upon our monitor */
        if (node == null) {
            EList list = monitor.getNodes();
            Iterator i = list.iterator();

            while (i.hasNext()) {
                node = (TRCNode) i.next();

                if (!node.eIsProxy()) {
                    String id = node.getRuntimeId();

                    if ((id != null) && id.equals(nodeIdRef)) {
                        context.setNode(node);

                        break;
                    }
                }
            }
        } else {
            if ((node.getRuntimeId() != null) && !node.getRuntimeId().equals(nodeIdRef)) {
                EList list = monitor.getNodes();
                Iterator i = list.iterator();

                while (i.hasNext()) {
                    node = (TRCNode) i.next();

                    if (!node.eIsProxy()) {
                        String id = node.getRuntimeId();

                        if ((id != null) && id.equals(nodeIdRef)) {
                            context.setNode(node);

                            break;
                        }
                    }
                }
            }
        }

        //node.setRuntimeId(nodeIdRef);
        process = LoadersUtils.locateProcessFromNode(node, pid, processId);

        if (process == null) {
            EList procExt = new BasicEList();
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;

            if (monitorFolder != null) {
                //create the process
                String pName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + node.getName().trim() + "_" + pid + "_" + processId;

                String pFileName = monitorFolder + pName;

                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcpxmi")).createResource(SaveUtil.createURI(pFileName + ".trcpxmi"));
				procDoc.setModified(true);
				
                HierarchyResourceSetImpl.getInstance().getResources().add(procDoc);

                //*** adding support for multiple files
//                SaveUtil.addDocument(procDoc);
            }

            process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            process.setPid(pid);

            if (processId != null) {
                process.setRuntimeId(processId);
            } else {
                process.setRuntimeId("0");
            }

            process.setNode(node);
            setProcessArguments(process);

            node.getProcessProxies().add(process);

            context.setProcessProxy(process);

            if (procDoc != null) {
                procDoc.getContents().add(process);
            }
        } else {
            /* We shouldn't need to do this but the launch case already contains the process
               without the ID and the location helper will return it.
             */
            process.setRuntimeId(processId);
			context.setProcessProxy(process);
        }
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		processId="0";
		nodeIdRef="0";
		application_executable="";
		name="unknown";
		process=null;
		pid=-1;
	}

    private void setProcessArguments(TRCProcessProxy process) {
        if (application_executable == null) {
            return;
        }

        String pName = "";
        String params = "";
        String vmparam = "";
        String classpath = "";

		int java_index = application_executable.indexOf("java.exe");
		if(java_index<0)
		{
			java_index = application_executable.indexOf("javaw.exe");
			if(java_index>0)
			{
				java_index +="javaw.exe".length();
			}
		}
		else
		{
			java_index +="java.exe".length();
		}
			
        if (java_index>0) {
            String exeName = application_executable.substring(java_index).trim();
			
//            if (!exeName.startsWith("-X")) { //log agents
//                exeName = "-X " + exeName;
//            }

            int idx = exeName.indexOf(" ");

			if(!exeName.startsWith("-"))
			{
				if ((idx != -1) && (idx < (exeName.length() + 1))) {
					exeName = exeName.substring(idx + 1);
				}
			}

            while (exeName.startsWith("-")) {
                if (exeName.startsWith("-cp") || exeName.startsWith("-classpath")) {
                    idx = exeName.indexOf(" ");

                    if (idx != -1) {
                        exeName = exeName.substring(idx).trim();
                    }

                    idx = exeName.indexOf(" ");

                    if (idx != -1) {
                        classpath = exeName.substring(0, idx);
                        exeName = exeName.substring(idx).trim();
                    }
                } else {
                    idx = exeName.indexOf(" ");

                    if (idx != -1) {
                        vmparam += (exeName.substring(0, idx) + " ");
                        exeName = exeName.substring(idx).trim();
                    }
                }
            }

            idx = exeName.indexOf(" ");

            if (idx != -1) {
                pName = exeName.substring(0, idx);
                params = exeName.substring(idx).trim();
            } else {
                pName = exeName;
            }
        }

        process.setName(pName);
        process.setClasspath(classpath);
        process.setParameters(params);
        process.setVmArguments(vmparam);
        process.setLaunchMode(1);
    }
}
