/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.util;

import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;

/**
 * @author slavescu
 */
public interface IHyadesResourceFactory extends Resource.Factory,IPagingListFactory{
	String LARGE_LOG_SUPPORT_DB_TYPE="largeLogSupportDBType";
	String LLSP_USERNAME = "largeLogSupportUsername";
	String LLSP_PASSWORD = "largeLogSupportPassword";
	
	boolean isEnabledFor(String postfix);

	IHyadesExtendedResource createResource(URI uri, Properties properties);
	IHyadesExtendedResource createResource(URI uri, Properties properties, Collection notLoaded);
	
	String getStoreType(String postfix);
}
