/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Unresolved Correlation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getContextId <em>Context Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getAgent <em>Agent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getSourceInfos <em>Source Infos</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UnresolvedCorrelationImpl extends EObjectImpl  implements UnresolvedCorrelation {
	/**
	 * The default value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextId()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTEXT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextId()
	 * @generated
	 * @ordered
	 */
	protected String contextId = CONTEXT_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSourceInfos() <em>Source Infos</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfos()
	 * @generated
	 * @ordered
	 */
	protected EList sourceInfos = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedCorrelationImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return HierarchyPackage.eINSTANCE.getUnresolvedCorrelation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContextId()
	{
		return contextId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContextId(String newContextId)
	{
		String oldContextId = contextId;
		contextId = newContextId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID, oldContextId, contextId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgent getAgent()
	{
		if (eContainerFeatureID != HierarchyPackage.UNRESOLVED_CORRELATION__AGENT) return null;
		return (TRCAgent)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgent(TRCAgent newAgent)
	{
		if (newAgent != eContainer || (eContainerFeatureID != HierarchyPackage.UNRESOLVED_CORRELATION__AGENT && newAgent != null)) {
			if (EcoreUtil.isAncestor(this, newAgent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newAgent != null)
				msgs = ((InternalEObject)newAgent).eInverseAdd(this, HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS, TRCAgent.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newAgent, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, newAgent, newAgent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSourceInfos()
	{
		if (sourceInfos == null) {
			sourceInfos = new EObjectContainmentWithInverseEList(CorrelationSourceInfo.class, this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO);
		}
		return sourceInfos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, msgs);
				case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
					return ((InternalEList)getSourceInfos()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
					return eBasicSetContainer(null, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, msgs);
				case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
					return ((InternalEList)getSourceInfos()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS, TRCAgent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				return getContextId();
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return getAgent();
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return getSourceInfos();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				setContextId((String)newValue);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				getSourceInfos().clear();
				getSourceInfos().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				setContextId(CONTEXT_ID_EDEFAULT);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				setAgent((TRCAgent)null);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				getSourceInfos().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				return CONTEXT_ID_EDEFAULT == null ? contextId != null : !CONTEXT_ID_EDEFAULT.equals(contextId);
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return getAgent() != null;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return sourceInfos != null && !sourceInfos.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (contextId: ");
		result.append(contextId);
		result.append(')');
		return result.toString();
	}

} //UnresolvedCorrelationImpl
