/*
 * Created on May 4, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.logc.internal.actions;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.models.cbe.*;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.sd.ui.internal.views.*;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenTimeBasedCorrelationViewPopupAction
	implements IViewActionDelegate, IObjectActionDelegate {

	private CBEDefaultEvent cbeEvent;
	private final String corrName = LogCorrelatorPlugin.getResourceString("CORR_NAME");
	
	public OpenTimeBasedCorrelationViewPopupAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart);
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		
		EObject mofObject = HyadesUtil.getMofObject();
		
		if (mofObject != null && mofObject instanceof EObject) {
			IWorkbenchPage persp = UIPlugin.getActivePage();

			try {
				SDViewer view = (SDViewer) persp.showView("org.eclipse.hyades.sd.ui.internal.views.SDViewer"); //$NON-NLS-1$

				if (view != null) {
					view.addLoadViewPage((EObject) mofObject,Graph.LOGoverRECORD,getCorrelation(corrName));

					if (cbeEvent != null
						&& cbeEvent instanceof CBECommonBaseEvent) {
						GraphNode node = view.getNodeByRecord((CBECommonBaseEvent) cbeEvent);
						if (node != null) {
							SDViewerPage currentPage = ((SDViewerPage) (view.getCurrentPage()));
							currentPage.getSdViewerUI().setSelectedNode((ColumnNode) node, ((ColumnFigure) node.getContainer()));
							currentPage.getSdViewerUI().scrollToNode((ColumnNode) node);
						}
					}
				}
			} catch (Exception e) {
				String msg = LogCorrelatorPlugin.getResourceString("STR_LOAD_SD_ERR_");
				Status err =
					new Status(
						Status.WARNING,
						ResourcesPlugin.PI_RESOURCES,
						IResourceStatus.INTERNAL_ERROR,
						e.toString(),
						null);
				IWorkbenchWindow window = SDPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
				ErrorDialog.openError(window.getShell(), msg, "", err);
				e.printStackTrace();
			}
		}
		mofObject = null;
		cbeEvent = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

		if (selection instanceof StructuredSelection
			&& ((StructuredSelection) selection).getFirstElement() != null
			&& ((StructuredSelection) selection).getFirstElement()
				instanceof CBEDefaultEvent) {
			cbeEvent =	(CBEDefaultEvent) (((StructuredSelection) selection).getFirstElement());
		}
	}


	protected IConfigurationElement getCorrelation(String name) {
		
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView"); //$NON-NLS-1$
		if (point != null) {
			
			IExtension[] extensions = point.getExtensions();			
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] elements =	extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++) {
					
					IConfigurationElement elem = elements[j];
					if ("view".equals(elements[j].getName()) //$NON-NLS-1$
					&& elements[j].getAttribute("name").equals(name))
						return elem;
				}
			}			
		}
		
		return null;
	}
}
