/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.hyades.execution.testgen.TestgenPlugin;


/**
 * Wizard page which prompts the user for the storage location and filename of the generated test 
 * @author Ernest Jessee
 */
public class TestSuiteLocationSelectionPage extends FileLocationSelectionWizardpage
{
	
	
	
	public String getDescription()
	{
		return TestgenPlugin.getResourceString("SELECT_SUITE_LOCATION_WIZARDPAGE_DESCRIPTION"); //$NON-NLS-1$
	}

	public String getFileExtension()
	{
		return "testsuite"; //$NON-NLS-1$
	}

	public String getFileNameLabel()
	{
		return TestgenPlugin.getResourceString("TestSuiteLocationSelectionPage.TEST_FILENAME_CONTROL_LABEL"); //$NON-NLS-1$
	}

	public String getPreferenceID()
	{
		return null;
	}

	public String getTitle()
	{
		return TestgenPlugin.getResourceString("TEST_GENERATION_WIZARD_TITLE"); //$NON-NLS-1$
	}

	public String getContextHelpID()
	{
		return "org.eclipse.hyades.execution.testgen.TestSuitePathSelector"; //$NON-NLS-1$
	}

}
