/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;
import org.w3c.dom.Element;
/**
 * <b>Describes component behavior</b>
 * Main role of the component is to provide dynamic managability.
 * 
 * @version 0.1
 * 
 */
public interface IComponent
{
	/**
	 * Method init.
	 * Sets all the context configuration properties based on the context config.
	 * @return boolean if init success
	 */
	boolean init();
	/**
	 * Method start. Starts component activity
	 */
	void start();
	/**
	 * Method stop. Stops the component activity
	 */
	void stop();
	/**
	 * Method update. Sets the component config with a root Element
	 * and then request the component to update based on that Element
	 * @param config string of config
	 * @throws AdapterInvalidConfig
	 */
	void update(Element config) throws AdapterInvalidConfig;
	/**
	 * Method update. By reading the current component config, sets the properties of 
	 * the component. Subclasses should invoke parent update() to ensure proper behaviour.
	 * @return
	 */
	void update() throws AdapterInvalidConfig;
	//=====basic getters and setters ==========================================
	/**
	 * Method log(String);
	 */
	public void log(String text, short severity);
	/**
	 * Method getContextConfiguration.
	 * @return Element - current config of the component
	 */
	Element getContextConfiguration();
	/**
	 * Sets the context config.
	 * @param config The configuration to set
	 */
	public void setContextConfiguration(Element newConfiguration);
	/**
	 * Method getConfiguration.
	 * @return Element - current config of the component
	 */
	Element getConfiguration();
	/**
	 * Sets the config.
	 * @param config The configuration to set
	 */
	public void setConfiguration(Element newConfiguration);
	/**
	 * Method returns the components this component manages
	 * @return org.eclipse.hyades.logging.adapter.IComponent[]
	 */
	IComponent[] getComponents();
	/**
	 * Method sets the list of components this component manages
	 */
	void setComponents(IComponent[] newComponents);
	/**
	 * Method returns loggin level of the component
	 * @return short
	 */
	short getLoggingLevel();
	/**
	 * Method sets logging level of the component
	 * @return void
	 */
	void setLoggingLevel(short newLevel);
	/**
	 * Method returns name of the component
	 * @return String
	 */
	String getName();
	/**
	 * Method sets name of the component
	 * @return String
	 */
	void setName(String newName);
	/**
	 * Method returns the role of the component
	 * @return String
	 */
	String getRole();
	/**
	 * Method sets the role of the component
	 * @return String
	 */
	void setRole(String newRole);
	/**
	 * Method returns the component description
	 * @return String
	 */
	String getDescription();
	/**
	 * Method sets the description of this component
	 * @return String
	 */
	void setDescription(String newDescription);
	/**
	 * Method returns the uniqueID of this component instance
	 * @return String
	 */
	String getUniqueID();
	/**
	 * Method sets the uniqueID of this component instance
	 * @return String
	 */
	void setUniqueID(String newUniqueID);
	/**
	 * Method returns the executable class name
	 * @return String
	 */
	String getExecutableClassName();
	/**
	 * Method sets executable class name
	 * @return String
	 */
	void setExecutableClassName(String newExecutableClassName);
	/**
	 * Method returns the role version
	 * @return String
	 */
	String getRoleVersion();
	/**
	 * Method sets role version
	 * @return String
	 */
	void setRoleVersion(String newRoleVersion);
	/**
	 * Method returns role creation date
	 * @return String
	 */
	String getRoleCreationDate();
	/**
	 * Method sets role creation time
	 * @return String
	 */
	void setRoleCreationDate(String newCreationDate);
	/**
	 * Method returns the version specific role description
	 * @return String
	 */
	String getRoleVersionDescription();
	/**
	 * Method sets the version specific role description
	 * @return String
	 */
	void setRoleVersionDescription(String newRoleVersionDescription);
	/**
	 * Method returns the version specific role description
	 * @return String
	 */
	String getImplementationVersion();
	/**
	 * Method sets the implementation version in the form of x.y.z where 
	 * x is a major release level, which may have api changes
	 * y is a minor release level with no api changes
	 * z is an optional fix level with no api changes
	 * @return String
	 */
	void setImplementationVersion(String newImplementationVersion);
	/**
	 * Method returns implementation creation date
	 * @return String
	 */
	String getImplementationCreationDate();
	/**
	 * Method sets implementation creation date
	 * @return String
	 */
	void setImplemenationCreationDate(String newImplementationCreationDate);
	/**
	 * Method returns implementation version description
	 * @return String
	 */
	String getImplementationVersionDescription();
	/**
	 * Method sets implementation version description
	 * @return String
	 */
	void setImplementationVersionDescription(String newImplementationVersionDescription);
}
