/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.internal.util.ComponentLoaderUtil;
/**
 * <p>Title: ComponentFactory.java</p>
 * <p>Description: Create Component objects
 * </p>
 * @author HS
 * @version 0.1
 * @see 
 **/
public class ComponentFactory
{
	private ComponentFactory()
	{
	}
	public static Component buildComponent(String classname, String id, String name)
	{
		Component component = null;
		if (classname != null)
		{
			component =
				(Component) ComponentLoaderUtil.instantiate(
					classname,
					"org.eclipse.hyades.logging.adapter.impl.Component");
			component.setName(name);
			component.setExecutableClassName(classname);
			component.setUniqueID(id);
		}
		return component;
	}
}
