/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.internal.util.ComponentLoaderUtil;
/**
 * <p>Title: ContextFactory.java</p>
 * <p>Description: Create Context objects
 * </p>
 * @author HS
 * @version 0.1
 **/
public class ContextFactory
{
	private ContextFactory()
	{
	}
	/**
	 * builds context by classname, id , name
	 */
	public static Context buildContext(String classname, String id, String name)
	{
		Context context = null;
		if (classname != null)
		{
			context =
				(Context) ComponentLoaderUtil.instantiate(classname, "org.eclipse.hyades.logging.adapter.impl.Context");
			context.setName(name);
			context.setUniqueID(id);
		}
		return context;
	}
}
