/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.util.*;
import org.eclipse.hyades.logging.adapter.util.Messages;
/**
 *
 */
public class ProcessUnit extends Component implements IProcessUnit
{
	protected boolean flushingMode = false;
	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(Object[])
	 */
	public Object[] processEventItems(Object[] msgs)
	{
		// processEventItems should be overridden by any serious Component
		log(Messages.getString("HyadesGA_CBE_ProcessUnit_Error",getUniqueID()),AdapterSensor.FATAL_LEVEL);
		
		return null;
	}
	/**
	 * flushEventItems should be overridden by any Component that buffers data
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#flushEventItems(java.lang.Object[])
	 */
	public Object[] flushEventItems(Object[] msgs)
	{
		flushingMode = true;
		Object[] temp = processEventItems(msgs);
		flushingMode = false;
		return temp;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItem(Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig
	{
		return null;
	}
}
