/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.outputters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 * @author smith
 *
 * This Outputter writes CBE's to a file 
 * 
 */
public class CBEFileOutputter extends ProcessUnit implements IOutputter
{
	/**
	 * directory address to start with, maybe relative or absolute 
	 */
	private String directory = null;
	/**
	 * relative file name (just name), maybe just regular expression 
	 */
	private String fileName = null;
	private String rawLogFileName = null;
	private File outputFile = null;
	private FileWriter fw = null;
		


	public Object[] processEventItems(Object[] msgs)
	{	
		if (msgs == null)
			return null;
			
		return processCBEs((ICommonBaseEvent[]) msgs);
	}
	
	/**
	 * Process CBE's passed in - write them to a file
	 * @param events CBE's to write to file
	 * @return ICommonBaseEvent[]
	 */
	private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] events)
	{
		for (int i = 0; i < events.length; i++)
		{
			if (events[i] != null) {
				
				// Write CBE to file
				try {
					fw.write(events[i].toString() + "\n");
					fw.flush();
				} catch (IOException ioe) {
					log(Messages.getString("HyadesGA_CBE_File_Outputter_Write_Error",getUniqueID(),rawLogFileName),AdapterSensor.FATAL_LEVEL);
				}
				
			}
		}
		return events;
	}
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig
	{
		if(!(msgs instanceof ICommonBaseEvent[])) {
			throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
		}
		return testProcessCBEs((ICommonBaseEvent[]) msgs);
	}
	private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] events)
	{
		return events;
	}
	
	/**
	 * Returns the directory.
	 * @return String
	 */
	final public String getDirectory()
	{
		return directory;
	}
	/**
	 * Returns the fileName.
	 * @return String
	 */
	final public String getFileName()
	{
		return fileName;
	}
	/**
	 * Sets the directory.
	 * @param directory The directory to set
	 */
	final public void setDirectory(String directory)
	{
		this.directory = directory;
	}
	/**
	 * Sets the fileName.
	 * @param fileName The fileName to set
	 */
	final public void setFileName(String fileName)
	{
		this.fileName = fileName;
	}
	
	/**
	 * update the configuration based on the configuration Element
	 */
	public void update() throws AdapterInvalidConfig
	{
		// first get the basic configuration set
		super.update();

		String directory = null;
		String fileName = null;
		
//		Get configuration
		Element outputterInstance = null;
		Element element = getConfiguration();
		// This outputter is configured with a sub element of the config
		NodeList outputters = element.getChildNodes();
		for (int i = 0; i < outputters.getLength(); i++)
			if (outputters.item(i).getNodeType() == Node.ELEMENT_NODE)
				outputterInstance = (Element) outputters.item(i);
//		Get attributes				
		if (outputterInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName")))
			directory = outputterInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
		if (outputterInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName")))
			fileName = outputterInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));

		setDirectory(directory);
		setFileName(fileName);

		/* If the directory does not end with the proper file
		 * separator then we need to add one.  RKD:  We probably
		 * need to make sure we convert incorrect path separators
		 * to the proper platform.
		 */
		String pathSeparator=System.getProperty("file.separator");
		if(getDirectory().endsWith(pathSeparator)) {
			rawLogFileName = getDirectory() + getFileName();
		}
		else {
			rawLogFileName = getDirectory() + pathSeparator + getFileName();
		}


		try {
			fw = new FileWriter(rawLogFileName);
		}
		catch (IOException ioe) {
			log(Messages.getString("HyadesGA_CBE_File_Outputter_Create_Error",getUniqueID(),rawLogFileName),AdapterSensor.FATAL_LEVEL);
			/* RKD: At this point there is no point if allowing this context to continue as we cannot access this outputter file.
			 */
			throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_File_Outputter_Create_Error"));
		}
	}	
}
