/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * @author rduggan
 *
 */
public class GroupStatement implements IStatement {
	
	private List ruleAttributes;
	private String name;

	/**
	 * @see org.eclipse.hyades.logging.adapter.IStatement#prepare(org.w3c.dom.Element)
	 */
	public void prepare(Element node, String path) throws PreparationException {
		
		if(path==null) {
			this.name=node.getAttribute(Messages.getString("HyadesGANameAttributeName"));
		}
		else {
			this.name=path+"."+node.getAttribute(Messages.getString("HyadesGANameAttributeName"));
		}
		
		/* Retrieve the index if there is one specified and embed this into the name */
		String index=node.getAttribute(Messages.getString("HyadesGAIndexAttributeName"));
		if(index!=null && !index.equals("")) {
			this.name=this.name+"["+index+"]";
		}
		
		/* Retrieve all the children and look for Group and RuleAtt elements. */ 
		NodeList children=node.getChildNodes();
		
		ruleAttributes=new ArrayList();
		
		for(int i=0; i<children.getLength(); i++) {
			Element child=null;
			try {
				child=(Element)children.item(i);
			}
			catch(ClassCastException e) {
				/* We can ignore this child as it is not a Element */	
				continue; 	
			}
			if(child.getNodeName().endsWith(Messages.getString("HyadesGARuleElementTagName"))) {
				IStatement statement=new GroupStatement();
				statement.prepare(child, name);
				ruleAttributes.add(statement);
			}
			else if(child.getNodeName().endsWith(Messages.getString("HyadesGARuleAttributeTagName"))) {
				IStatement statement=new AttributeStatement();
				statement.prepare(child, name);
				ruleAttributes.add(statement);	
			}
		}
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.IStatement#run(java.lang.String, null)
	 */
	public boolean run(String line, HashMap inputs, List outputs) {
		if (ruleAttributes!=null) {
			ListIterator iterator=ruleAttributes.listIterator();
			while(iterator.hasNext()) {
				IStatement statement=(IStatement)iterator.next();
				statement.run(line, inputs, outputs);
			}
		}
		return false;
	}
}
