/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TypeChecker {

	public static final String JAVA_TYPE_VOID = "void"; //$NON-NLS-1$
	public static final String JAVA_TYPE_BOOLEAN = "boolean"; //$NON-NLS-1$
	public static final String JAVA_TYPE_BYTE = "byte"; //$NON-NLS-1$
	public static final String JAVA_TYPE_SHORT = "short"; //$NON-NLS-1$
	public static final String JAVA_TYPE_INT = "int"; //$NON-NLS-1$
	public static final String JAVA_TYPE_LONG = "long"; //$NON-NLS-1$
	public static final String JAVA_TYPE_FLOAT = "float"; //$NON-NLS-1$
	public static final String JAVA_TYPE_DOUBLE = "double"; //$NON-NLS-1$
	public static final String JAVA_TYPE_CHAR = "char"; //$NON-NLS-1$

	public static final String JAVA_OBJ_TYPE_BOOLEAN = "java.lang.Boolean"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_BYTE = "java.lang.Byte"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_SHORT = "java.lang.Short"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_INTEGER = "java.lang.Integer"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_LONG = "java.lang.Long"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_FLOAT = "java.lang.Float"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_DOUBLE = "java.lang.Double"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_CHAR = "java.lang.Character";	 //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_STRING = "java.lang.String"; //$NON-NLS-1$

	public static final String JAVA_OBJ_TYPE_BOOLEAN_SN = "Boolean"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_BYTE_SN = "Byte"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_SHORT_SN = "Short"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_INTEGER_SN = "Integer"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_LONG_SN = "Long"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_FLOAT_SN = "Float"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_DOUBLE_SN = "Double"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_CHAR_SN = "Character"; //$NON-NLS-1$
	public static final String JAVA_OBJ_TYPE_STRING_SN = "String"; //$NON-NLS-1$

	public static final String CSHARP_TYPE_BOOL = "bool"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_SBYTE = "sbyte"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_BYTE = "byte"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_USHORT = "ushort"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_SHORT = "short"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_UINT = "uint"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_INT = "int"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_ULONG = "ulong"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_LONG = "long"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_FLOAT = "float"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_DOUBLE = "double"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_DECIMAL = "decimal";	 //$NON-NLS-1$
	public static final String CSHARP_TYPE_CHAR = "char"; //$NON-NLS-1$
	public static final String CSHARP_TYPE_STRING = "string"; //$NON-NLS-1$

	public static final String CSHARP_OBJ_TYPE_BOOL = "System.Boolean"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_SBYTE = "System.SByte"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_BYTE = "System.Byte"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_USHORT = "System.UInt16"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_SHORT = "System.Int16"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_UINT = "System.UInt32"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_INT = "System.Int32"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_ULONG = "System.UInt64"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_LONG = "System.Int64"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_FLOAT = "System.Single"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_DOUBLE = "System.Double"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_DECIMAL = "System.Decimal";	 //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_CHAR = "System.Char"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_STRING = "System.String"; //$NON-NLS-1$

	public static final String CSHARP_OBJ_TYPE_BOOL_SN = "Boolean"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_SBYTE_SN = "SByte"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_BYTE_SN = "Byte"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_USHORT_SN = "UInt16"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_SHORT_SN = "Int16"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_UINT_SN = "UInt32"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_INT_SN = "Int32"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_ULONG_SN = "UInt64"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_LONG_SN = "Int64"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_FLOAT_SN = "Single"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_DOUBLE_SN = "Double"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_DECIMAL_SN = "Decimal";	 //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_CHAR_SN = "Char"; //$NON-NLS-1$
	public static final String CSHARP_OBJ_TYPE_STRING_SN = "String"; //$NON-NLS-1$
	
	public static final String CPP_TYPE_VOID = "void"; //$NON-NLS-1$
	public static final String CPP_TYPE_CHAR = "char"; //$NON-NLS-1$
	public static final String CPP_TYPE_SINT = "short int"; //$NON-NLS-1$
	public static final String CPP_TYPE_INT = "int"; //$NON-NLS-1$
	public static final String CPP_TYPE_LINT = "long int"; //$NON-NLS-1$
	public static final String CPP_TYPE_FLOAT = "float"; //$NON-NLS-1$
	public static final String CPP_TYPE_DOUBLE = "double"; //$NON-NLS-1$
	public static final String CPP_TYPE_LDOUBLE = "long double";	 //$NON-NLS-1$
	public static final String CPP_TYPE_S_CHAR = "signed char"; //$NON-NLS-1$
	public static final String CPP_TYPE_S_SINT = "signed short int"; //$NON-NLS-1$
	public static final String CPP_TYPE_S_INT = "signed int"; //$NON-NLS-1$
	public static final String CPP_TYPE_S_LINT = "signed long int"; //$NON-NLS-1$
	public static final String CPP_TYPE_U_CHAR = "unsigned char"; //$NON-NLS-1$
	public static final String CPP_TYPE_U_SINT = "unsigned short int"; //$NON-NLS-1$
	public static final String CPP_TYPE_U_INT = "unsigned int"; //$NON-NLS-1$
	public static final String CPP_TYPE_U_LINT = "unsigned long int"; //$NON-NLS-1$
	public static final int LANG_JAVA = 1;
	public static final int LANG_CSHARP = 2;
	public static final int LANG_CPP = 3;
	
	private int languageType = 0;
	
	private static final TypeChecker instance = new TypeChecker();

	public static TypeChecker getInstance()
	{
		return instance;
	}
	
	protected TypeChecker()
	{
	}
	
	public void setLanguageType(int type)
	{
		if(type < 1 || type > 3)
			return;
		languageType = type;
	}
	
	public boolean isNumber(String type)
	{
		if(languageType == 0 || languageType == LANG_JAVA)
		{
			if(type.equals(JAVA_TYPE_DOUBLE) ||
				type.equals(JAVA_TYPE_FLOAT) ||
				type.equals(JAVA_TYPE_LONG) ||
				type.equals(JAVA_TYPE_SHORT) ||
				type.equals(JAVA_OBJ_TYPE_DOUBLE) ||
				type.equals(JAVA_OBJ_TYPE_DOUBLE_SN) ||
				type.equals(JAVA_OBJ_TYPE_FLOAT) ||
				type.equals(JAVA_OBJ_TYPE_FLOAT_SN)||
				type.equals(JAVA_OBJ_TYPE_INTEGER) ||
				type.equals(JAVA_OBJ_TYPE_INTEGER_SN) ||
				type.equals(JAVA_OBJ_TYPE_LONG) ||
				type.equals(JAVA_OBJ_TYPE_LONG_SN) ||
				type.equals(JAVA_OBJ_TYPE_SHORT) ||
				type.equals(JAVA_OBJ_TYPE_SHORT_SN))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CSHARP)
		{
			if(type.equals(CSHARP_OBJ_TYPE_DECIMAL) ||
				type.equals(CSHARP_OBJ_TYPE_DECIMAL_SN) ||
				type.equals(CSHARP_OBJ_TYPE_DOUBLE) ||
				type.equals(CSHARP_OBJ_TYPE_DOUBLE_SN) ||
				type.equals(CSHARP_OBJ_TYPE_FLOAT) ||
				type.equals(CSHARP_OBJ_TYPE_FLOAT_SN) ||
				type.equals(CSHARP_OBJ_TYPE_INT) ||
				type.equals(CSHARP_OBJ_TYPE_INT_SN) ||
				type.equals(CSHARP_OBJ_TYPE_LONG) ||
				type.equals(CSHARP_OBJ_TYPE_LONG_SN) ||
				type.equals(CSHARP_OBJ_TYPE_SHORT) ||
				type.equals(CSHARP_OBJ_TYPE_SHORT_SN) ||
				type.equals(CSHARP_OBJ_TYPE_UINT) ||
				type.equals(CSHARP_OBJ_TYPE_UINT_SN) ||
				type.equals(CSHARP_OBJ_TYPE_ULONG) ||
				type.equals(CSHARP_OBJ_TYPE_ULONG_SN) ||
				type.equals(CSHARP_OBJ_TYPE_USHORT) ||
				type.equals(CSHARP_OBJ_TYPE_USHORT_SN) ||
				type.equals(CSHARP_TYPE_DECIMAL) ||
				type.equals(CSHARP_TYPE_FLOAT) ||
				type.equals(CSHARP_TYPE_INT) ||
				type.equals(CSHARP_TYPE_LONG) ||
				type.equals(CSHARP_TYPE_SHORT) ||
				type.equals(CSHARP_TYPE_UINT) ||
				type.equals(CSHARP_TYPE_ULONG) ||
				type.equals(CSHARP_TYPE_USHORT))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CPP)
		{
			if(type.equals(CPP_TYPE_DOUBLE) ||
				type.equals(CPP_TYPE_FLOAT) ||
				type.equals(CPP_TYPE_SINT) ||
				type.equals(CPP_TYPE_INT) ||
				type.equals(CPP_TYPE_LINT) ||
				type.equals(CPP_TYPE_LDOUBLE) ||
				type.equals(CPP_TYPE_S_INT) ||
				type.equals(CPP_TYPE_S_LINT) ||
				type.equals(CPP_TYPE_S_SINT) ||
				type.equals(CPP_TYPE_U_INT) ||
				type.equals(CPP_TYPE_U_LINT) ||
				type.equals(CPP_TYPE_U_SINT))
				return true;
		}
		return false;
	}
	
	public boolean isBoolean(String type)
	{
		if(languageType == 0 || languageType == LANG_JAVA)
		{
			if(type.equals(JAVA_TYPE_BOOLEAN) ||
				type.equals(JAVA_OBJ_TYPE_BOOLEAN) ||
				type.equals(JAVA_OBJ_TYPE_BOOLEAN_SN))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CSHARP)
		{
			if(type.equals(CSHARP_TYPE_BOOL) ||
				type.equals(CSHARP_OBJ_TYPE_BOOL) ||
				type.equals(CSHARP_OBJ_TYPE_BOOL_SN))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CPP)
		{
		}
		return false;
	}
	
	public boolean isString(String type)
	{
		if(languageType == 0 || languageType == LANG_JAVA)
		{
			if(type.equals(JAVA_OBJ_TYPE_STRING) ||
				type.equals(JAVA_OBJ_TYPE_STRING_SN))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CSHARP)
		{
			if(type.equals(CSHARP_OBJ_TYPE_STRING) ||
				type.equals(CSHARP_OBJ_TYPE_STRING_SN) ||
				type.equals(CSHARP_TYPE_STRING))
				return true;
		}
		if(languageType == 0 || languageType == LANG_CPP)
		{
		}
		return false;
		
	}
	
	public boolean isEnumeration(String type)
	{
		if(languageType == 0 || languageType == LANG_JAVA)
		{
			try
			{
				Object cls = Class.forName(type);
				if(cls instanceof Enumeration)
					return true;
			}
			catch(Exception e)
			{
			}
		}
		return false;
	}
	
	public boolean isPrimitive(String type, boolean includeVoid)
	{
		if(languageType == 0 || languageType == LANG_JAVA)
		{
			if(type.equals(JAVA_TYPE_BOOLEAN) ||
				type.equals(JAVA_TYPE_BYTE) ||
				type.equals(JAVA_TYPE_CHAR) ||
				type.equals(JAVA_TYPE_DOUBLE) ||
				type.equals(JAVA_TYPE_FLOAT) ||
				type.equals(JAVA_TYPE_INT) ||
				type.equals(JAVA_TYPE_LONG) ||
				type.equals(JAVA_TYPE_SHORT))
				return true;
			if(includeVoid)
			{
				if(type.equals(JAVA_TYPE_VOID))
					return true;
			}
		}
		if(languageType == 0 || languageType == LANG_CSHARP)
		{
			return false;
		}
		if(languageType == 0 || languageType == LANG_CPP)
		{
			if(type.equals(CPP_TYPE_DOUBLE) ||
				type.equals(CPP_TYPE_FLOAT) ||
				type.equals(CPP_TYPE_SINT) ||
				type.equals(CPP_TYPE_INT) ||
				type.equals(CPP_TYPE_LINT) ||
				type.equals(CPP_TYPE_LDOUBLE) ||
				type.equals(CPP_TYPE_CHAR) ||
				type.equals(CPP_TYPE_U_CHAR) ||
				type.equals(CPP_TYPE_S_CHAR) ||
				type.equals(CPP_TYPE_S_INT) ||
				type.equals(CPP_TYPE_S_LINT) ||
				type.equals(CPP_TYPE_S_SINT) ||
				type.equals(CPP_TYPE_U_INT) ||
				type.equals(CPP_TYPE_U_LINT) ||
				type.equals(CPP_TYPE_U_SINT))
				return true;
			if(includeVoid)
			{
				if(type.equals(CPP_TYPE_VOID))
					return true;
			}			
		}
		
		return false;		
	}
}
