package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * The ContextDataElement type defines the context(s) that this event references.
 * This complex type holds data that is used to assist with problem diagnostics 
 * by correlating messages or events generated during execution of a unit of work.
 * 
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ContextDataElementImpl implements IContextDataElement, Serializable, Cloneable {

    //define the serialiVersionUID for serialization
    //if this object is ever changed that breaks backward compatability
    //this value MUST be changed Every effort should be made not to
    //break backward compatability
    static final long serialVersionUID = -3888096669772662967L;

    // define the fields that will be serialized. 
    // if any new variables are added to the class
    // this table should be updated along with the readObject and writeObject methods
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("contextId", String.class), new ObjectStreamField("type", String.class), new ObjectStreamField("name", String.class), new ObjectStreamField("contextValue", String.class), };

    /**
     * Fields.
     */
    protected String contextId = null;
    protected String type = null;
    protected String name = null;
    protected String contextValue = null;

    /**
     * Constructor for ContextDataElementImpl.
     */
    protected ContextDataElementImpl() {
        super();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getContextId()
     */
    public String getContextId() {
        return contextId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getContextValue()
     */
    public String getContextValue() {
        return contextValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getType()
     */
    public String getType() {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setContextId(String)
     */
    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setContextValue(String)
     */
    public void setContextValue(String contextValue) {
        this.contextValue = contextValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setName(String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setType(String)
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
    * Determines is two different objects are equal.
    */
    public boolean equals(Object obj) {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            result = true;
        }
        else {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof ContextDataElementImpl) && (getClass() == obj.getClass())) {
                ContextDataElementImpl contextDataElement = (ContextDataElementImpl) obj;

                Object property1;
                Object property2;

                property1 = getContextId();
                property2 = contextDataElement.getContextId();

                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                    property1 = getType();
                    property2 = contextDataElement.getType();

                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                        property1 = getName();
                        property2 = contextDataElement.getName();

                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                            property1 = getContextValue();
                            property2 = contextDataElement.getContextValue();

                            if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                result = true;
                            }
                        }
                    }
                }
            }
        }

        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        // set the values of the Serializable fields
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("name", name);
        fields.put("type", type);
        fields.put("contextId", contextId);
        fields.put("contextValue", contextValue);
        // save them
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        // prepare to read the alternate persistent fields
        ObjectInputStream.GetField fields = null;
        fields = in.readFields();

        // read the alternate persistent fields
        name = (String) fields.get("name", name);
        type = (String) fields.get("type", type);
        contextId = (String) fields.get("contextId", contextId);
        contextValue = (String) fields.get("contextValue", contextValue);
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.IContextDataElement#init()
     * @since 1.0.1
     */
    public void init() {
        contextId = null;
        type = null;
        name = null;
        contextValue = null;
    }
}
