/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.sample.loganalyzer;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

/**
 * @author sleeloy
 *
 * This is a wizard page class that contains the project name and path
 * that will be used to create the sample project in the workbench.
 * 
 * @see org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage
 */
public class LogAnalyzerCreationPage extends CreationWizardPage {

	/**
	 * Constructor.
	 * 
	 * @param creationWizard - the wizard that this page is part of
	 * @param pageName - the page name
	 * @param configurationElement - configuration element that configures the wizard page
	 */
	public LogAnalyzerCreationPage(
		CreationWizard creationWizard,
		String pageName,
		IConfigurationElement configurationElement) {
		super(creationWizard, pageName, configurationElement);
	}
	
	/**
	 * Returns the project's text widget that is defined in this
	 * wizard's superclass.
	 * @return Text - the project text widget.
	 */
	public Text getProjectText()
	{
		if(!(getControl() instanceof Composite))
			return null;
			
		if(getProjectName() == null)
			return null;
			
		Composite parent = (Composite)getControl();
		Control[] children = parent.getChildren();
		for(int i = 0; i < children.length; i++)
		{
			if(children[i] instanceof Composite)
			{
				Control[] grandChildren = ((Composite)children[i]).getChildren();
				for(int j = 0; j < grandChildren.length; j++)
				{
					if(grandChildren[j] instanceof Text)
					{
						Text text = (Text)grandChildren[j];
						if(getProjectName().equals(text.getText()))
							return text;
					}
				}
			}
		}
		
		return null;
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.dialogs.WizardNewProjectCreationPage#validatePage()
	 */
	protected boolean validatePage() {
			
		String projectName = getProjectName();
		if(projectName == null)
			return false;
		if (getWizard() instanceof LogAnalyzerCreationWizard)
		{
			LogAnalyzerCreationWizard wizard = (LogAnalyzerCreationWizard)getWizard();
			LogAnalyzerSamplePage samplePage = wizard.getPageTwo();
			if (samplePage != null)
			{
				samplePage.setAccessLog(this.getLocationPath().toString());
				samplePage.setErrorLog(this.getLocationPath().toString());
			}
		}
		
		return true;
	}
	protected boolean projectValidatePage() {
		IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();

		String projectFieldContents = this.getProjectText().getText();
		if (projectFieldContents.equals("")) { //$NON-NLS-1$
			setErrorMessage(null);
			setMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectNameEmpty")); //$NON-NLS-1$
			return false;
		}
	
		IStatus nameStatus =
			workspace.validateName(projectFieldContents, IResource.PROJECT);
		if (!nameStatus.isOK()) {
			setErrorMessage(nameStatus.getMessage());
			return false;
		}
 

		if (getProjectHandle().exists()) {
			setErrorMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectExistsMessage")); //$NON-NLS-1$
			return false;
		}

		setErrorMessage(null);
		setMessage(null);
		return true;
	}
}
