/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model;

import java.util.ArrayList;
import java.util.List;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class Loop
extends Action implements IActionOwner
{
	private int iterations;
	private List actions;
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.Action#dispose()
	 */
	public void dispose()
	{
		if(actions != null)
			actions.clear();
		super.dispose();
	}
	
	public List getActions()
	{
		if(actions == null)
			actions = new ArrayList();
		return actions;
	}

	public int getIterations()
	{
		return iterations;
	}

	public void setIterations(int iteractions)
	{
		this.iterations = iteractions;
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		int i = (getIterations() > 0)?getIteration():0;
		StringBuffer sb = new StringBuffer(super.toString().trim());
		sb.append(" (").append(getIterations()).append(".").append(i).append(")");
		return sb.toString();
	}	
}
