/*
 * Created on Oct 30, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.probekit.internal;
import java.util.jar.*;
import java.io.*;

/**
 * @author apratt
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class JarReader {
	private JarInputStream fJarInputStream;
	
	public JarReader(File jarFile) throws IOException {
		fJarInputStream = new JarInputStream(new FileInputStream(jarFile));
	}

	public Manifest getManifest() throws IOException {
		return fJarInputStream.getManifest();
	}

	/**
	 * Extract all files to the indicated direcotry, then closes the Jar file. 
	 * The directory should already exist.
	 * 
	 * @param targetDirectory the destination directory for the jar contents. Should exist.
	 * @throws IOException to indicate errors
	 */	
	public void extractAll(File targetDirectory) throws IOException {
		if (!targetDirectory.exists()) {
			throw new IOException("Jar extract: target directory does not exist");
		}
		JarEntry entry;
		while ((entry = fJarInputStream.getNextJarEntry()) != null) {
			if (entry.getName().startsWith("..")) {
				// this is a malformed jar which I don't want to touch with a ten-foot pole.
				// Unfortunately, the Rational ClearCase plugin suffers from this.
				throw new IOException("Invalid jar entry starts with \"..\": " + entry.getName());
			}
			if (entry.isDirectory()) {
				// Doesn't happen
				String subdirName = entry.getName();
				File newSubDir = new File(targetDirectory, subdirName);
				if (!newSubDir.exists() && !newSubDir.mkdirs()) {
					throw new IOException("Jar extract: failed to create subdirectory");
				}
			}
			else {
				String entryName = entry.getName();
				// Pick off the directory name part and mkdir it if necessary
				int lastSlash = entryName.lastIndexOf('/');
				if (lastSlash != -1) {
					String dirPart = entryName.substring(0, lastSlash);
					File dirFile = new File(targetDirectory.getCanonicalPath() + File.separator + dirPart);
					if (!dirFile.exists()) {
						if (!dirFile.mkdirs()) {
							throw new IOException("Jar extract: Failed to make directories");
						}
					}
					else if (!dirFile.isDirectory()) {
						throw new IOException("Jar extract: subdir for entry exists and is not a directory");
					}
					// else it exists and is a directory
				}
				File newFile = new File(targetDirectory, entryName);
				if (!newFile.createNewFile()) {
					throw new IOException("Jar extract: failed to create file");
				}
				
				int uncompressedSize = (int)entry.getSize();
				FileOutputStream fos = new FileOutputStream(newFile);
				int bufferSize = Math.max(uncompressedSize, 4096);
				byte[] buffer = new byte[bufferSize];
				int actualCount;
				while ((actualCount = fJarInputStream.read(buffer, 0, bufferSize)) != -1) {
					fos.write(buffer, 0, actualCount);
				}
				fos.close();
			}
		}
	}
	
	public void close() throws IOException {
		if (fJarInputStream != null) {
			fJarInputStream.close();
		} 
	}
}
