/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.hyades.loaders.util.*;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;


public class XMLnodeLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String hostname;
    private String ipaddress;
    private String nodeId;
    private double timezone;

    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.models.loader.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
        if (name.equals("nodeId")) {
            nodeId = value;
        } else if (name.equals("hostname")) {
            hostname = value;
        } else if (name.equals("ipaddress")) {
			ipaddress = value;
        } else if (name.equals("timezone")) {
            timezone = Double.valueOf(value).doubleValue();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext(org.eclipse.hyades.models.hierarchy.TRCMonitor)
     */
    public void addYourselfInContext() {
        TRCMonitor monitor = context.getMonitor();

        if (monitor == null) {
            return;
        }

        /* We need a runtimeId to even attempt to create a node */
        if (nodeId == null) {
            return;
        }

        /* If the hostname is not yet set, assign it to be the default */
        if (hostname == null) {
            hostname = "_unknown";
        }

        /* If the node isn't known lets look for it */
        TRCNode node = context.getNode();

        if (node == null) {
            node = LoadersUtils.locateNodeFromMonitor(context.getMonitor(), hostname, ipaddress, nodeId);
        } else {
            String rId = node.getRuntimeId();

            if ((rId != null) && !rId.equals(nodeId)) {
                node = LoadersUtils.locateNodeFromMonitor(monitor, hostname, ipaddress, nodeId);
            }
        }

        if (node == null) {
            //create the node
            EList nExt = new BasicEList();
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource nDoc = null;

            if (monitorFolder != null) {
                String nName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + hostname.trim();

                String nodeFileName = monitorFolder + nName;

                nDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(nodeFileName + ".trcnxmi")).createResource(SaveUtil.createURI(nodeFileName + ".trcnxmi"));
                nDoc.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add(nDoc);

                //*** adding support for multiple files
//                SaveUtil.addDocument(nDoc);
            }

            node = HierarchyFactory.eINSTANCE.createTRCNode();
            node.setName(hostname);
            node.setRuntimeId(nodeId);
            node.setMonitor(monitor);

            if (nDoc != null) {
                nDoc.getContents().add(node);
            }
        } else {
            node.setIpAddress(ipaddress);
            node.setRuntimeId(nodeId);
            node.setTimezone(timezone);
        }

		context.setNode(node);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        hostname = null;
        ipaddress = null;
        nodeId = null;
        timezone = 0;
    }
}
