/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author jtoomey
 *
 * This is the loop event loader
 */
public class XMLloopEventLoader extends XMLexecutionEventLoader {
	// static variables
	protected final static String EVENT_LOOP_ITERATIONS = "iterations";
	protected final static String EVENT_LOOP_ASYCHRONOUS = "asychronous";
	
	// Attribute variables
	protected long iterations = 0;
	protected boolean asychronous = false;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		iterations = 0;
		asychronous = false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_LOOP_ASYCHRONOUS_int :
			asychronous = Boolean.getBoolean(value);
			break;

		case ExecutionConstants.EVENT_LOOP_ITERATIONS_int :
			iterations = Integer.parseInt(value);
			break;
		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		
		// Create the event
		TPFLoopEvent loopEvent = Common_TestprofileFactoryImpl.eINSTANCE.createTPFLoopEvent();
		
		// Now populate the specialized attributes
		loopEvent.setAsynchronous(asychronous);
		loopEvent.setIterations(iterations);
		
		// populate the event with the base event attributes
		event = (TPFExecutionEvent) loopEvent;
		super.addYourselfToContainer();
		super.addYourselfInContext();
		
	}

}
