/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
package org.eclipse.hyades.models.common.common.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.common.CMNMachine;
import org.eclipse.hyades.models.common.common.CommonPackage;

import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTimezone;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CMN Machine</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class CMNMachineImpl extends CMNNodeTypeImpl implements CMNMachine {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CMNMachineImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return CommonPackage.eINSTANCE.getCMNMachine();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicAdd(otherEnd, msgs);
				case CommonPackage.CMN_MACHINE__DEPLOYMENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CommonPackage.CMN_MACHINE__DEPLOYMENT, msgs);
				case CommonPackage.CMN_MACHINE__TIMEZONE:
					if (timezone != null)
						msgs = ((InternalEObject)timezone).eInverseRemove(this, Common_TestprofilePackage.TPF_TIMEZONE__LOCATIONS, TPFTimezone.class, msgs);
					return basicSetTimezone((TPFTimezone)otherEnd, msgs);
				case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicAdd(otherEnd, msgs);
				case CommonPackage.CMN_MACHINE__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CommonPackage.CMN_MACHINE__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicRemove(otherEnd, msgs);
				case CommonPackage.CMN_MACHINE__DEPLOYMENT:
					return eBasicSetContainer(null, CommonPackage.CMN_MACHINE__DEPLOYMENT, msgs);
				case CommonPackage.CMN_MACHINE__TIMEZONE:
					return basicSetTimezone(null, msgs);
				case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicRemove(otherEnd, msgs);
				case CommonPackage.CMN_MACHINE__PARENT:
					return eBasicSetContainer(null, CommonPackage.CMN_MACHINE__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case CommonPackage.CMN_MACHINE__DEPLOYMENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, TPFDeployment.class, msgs);
				case CommonPackage.CMN_MACHINE__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS, CFGLocation.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_MACHINE__ID:
				return getId();
			case CommonPackage.CMN_MACHINE__DESCRIPTION:
				return getDescription();
			case CommonPackage.CMN_MACHINE__NAME:
				return getName();
			case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
				return getPropertyGroups();
			case CommonPackage.CMN_MACHINE__DEPLOYMENT:
				return getDeployment();
			case CommonPackage.CMN_MACHINE__TIMEZONE:
				if (resolve) return getTimezone();
				return basicGetTimezone();
			case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
				return getSubLocations();
			case CommonPackage.CMN_MACHINE__PARENT:
				return getParent();
			case CommonPackage.CMN_MACHINE__REF_SUB_LOCATIONS:
				return getRefSubLocations();
			case CommonPackage.CMN_MACHINE__HOSTNAME:
				return getHostname();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_MACHINE__ID:
				setId((String)newValue);
				return;
			case CommonPackage.CMN_MACHINE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case CommonPackage.CMN_MACHINE__NAME:
				setName((String)newValue);
				return;
			case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				getPropertyGroups().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_MACHINE__DEPLOYMENT:
				setDeployment((TPFDeployment)newValue);
				return;
			case CommonPackage.CMN_MACHINE__TIMEZONE:
				setTimezone((TPFTimezone)newValue);
				return;
			case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
				getSubLocations().clear();
				getSubLocations().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_MACHINE__PARENT:
				setParent((CFGLocation)newValue);
				return;
			case CommonPackage.CMN_MACHINE__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				getRefSubLocations().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_MACHINE__HOSTNAME:
				setHostname((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_MACHINE__ID:
				setId(ID_EDEFAULT);
				return;
			case CommonPackage.CMN_MACHINE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case CommonPackage.CMN_MACHINE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				return;
			case CommonPackage.CMN_MACHINE__DEPLOYMENT:
				setDeployment((TPFDeployment)null);
				return;
			case CommonPackage.CMN_MACHINE__TIMEZONE:
				setTimezone((TPFTimezone)null);
				return;
			case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
				getSubLocations().clear();
				return;
			case CommonPackage.CMN_MACHINE__PARENT:
				setParent((CFGLocation)null);
				return;
			case CommonPackage.CMN_MACHINE__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				return;
			case CommonPackage.CMN_MACHINE__HOSTNAME:
				setHostname(HOSTNAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_MACHINE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case CommonPackage.CMN_MACHINE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case CommonPackage.CMN_MACHINE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case CommonPackage.CMN_MACHINE__PROPERTY_GROUPS:
				return propertyGroups != null && !propertyGroups.isEmpty();
			case CommonPackage.CMN_MACHINE__DEPLOYMENT:
				return getDeployment() != null;
			case CommonPackage.CMN_MACHINE__TIMEZONE:
				return timezone != null;
			case CommonPackage.CMN_MACHINE__SUB_LOCATIONS:
				return subLocations != null && !subLocations.isEmpty();
			case CommonPackage.CMN_MACHINE__PARENT:
				return getParent() != null;
			case CommonPackage.CMN_MACHINE__REF_SUB_LOCATIONS:
				return refSubLocations != null && !refSubLocations.isEmpty();
			case CommonPackage.CMN_MACHINE__HOSTNAME:
				return HOSTNAME_EDEFAULT == null ? hostname != null : !HOSTNAME_EDEFAULT.equals(hostname);
		}
		return eDynamicIsSet(eFeature);
	}

} //CMNMachineImpl
