/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ICondition;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRGate;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperator;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Combined Fragment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getInteractionOperator <em>Interaction Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getGates <em>Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getInteractionOperands <em>Interaction Operands</em>}</li>
 * </ul>
 * </p>
 *
 * @extends IDecision, ILoop
 * @generated NOT
 */
public class BVRCombinedFragmentImpl extends BVRInteractionFragmentImpl	implements BVRCombinedFragment, IDecision, ILoop {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getInteractionOperator() <em>Interaction Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperator()
	 * @generated
	 * @ordered
	 */
	protected static final BVRInteractionOperator INTERACTION_OPERATOR_EDEFAULT = BVRInteractionOperator.ALT_LITERAL;

	/**
	 * The cached value of the '{@link #getInteractionOperator() <em>Interaction Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperator()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionOperator interactionOperator = INTERACTION_OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getGates() <em>Gates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGates()
	 * @generated
	 * @ordered
	 */
	protected EList gates = null;

	/**
	 * The cached value of the '{@link #getInteractionOperands() <em>Interaction Operands</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperands()
	 * @generated
	 * @ordered
	 */
	protected EList interactionOperands = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRCombinedFragmentImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_Behavior_FragmentsPackage.eINSTANCE.getBVRCombinedFragment();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionOperator getInteractionOperator()
	{
		return interactionOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionOperator(BVRInteractionOperator newInteractionOperator)
	{
		BVRInteractionOperator oldInteractionOperator = interactionOperator;
		interactionOperator = newInteractionOperator == null ? INTERACTION_OPERATOR_EDEFAULT : newInteractionOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR, oldInteractionOperator, interactionOperator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getGates()
	{
		if (gates == null) {
			gates = new EObjectContainmentEList(BVRGate.class, this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES);
		}
		return gates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInteractionOperands()
	{
		if (interactionOperands == null) {
			interactionOperands = new EObjectContainmentWithInverseEList(BVRInteractionOperand.class, this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT);
		}
		return interactionOperands;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
					return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
					return ((InternalEList)getMessages()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
					if (defaultApplication != null)
						msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION, null, msgs);
					return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
					return ((InternalEList)getInteractionOperands()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
					return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GENERAL_ORDERINGS:
					return ((InternalEList)getGeneralOrderings()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
					return ((InternalEList)getMessages()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
					return eBasicSetContainer(null, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__PROPERTIES:
					return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
					return basicSetDefaultApplication(null, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
					return ((InternalEList)getGates()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
					return ((InternalEList)getInteractionOperands()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__ID:
				return getId();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DESCRIPTION:
				return getDescription();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__NAME:
				return getName();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
				return getLifelines();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GENERAL_ORDERINGS:
				return getGeneralOrderings();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
				return getMessages();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
				return getInteraction();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__PROPERTIES:
				return getProperties();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
				return getDefaultApplication();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				return getInteractionOperator();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				return getGates();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return getInteractionOperands();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__ID:
				setId((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__NAME:
				setName((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
				getLifelines().clear();
				getLifelines().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				getGeneralOrderings().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				setInteractionOperator((BVRInteractionOperator)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				getGates().clear();
				getGates().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				getInteractionOperands().clear();
				getInteractionOperands().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
				getLifelines().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
				getMessages().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__PROPERTIES:
				getProperties().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)null);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				setInteractionOperator(INTERACTION_OPERATOR_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				getGates().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				getInteractionOperands().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__LIFELINES:
				return lifelines != null && !lifelines.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GENERAL_ORDERINGS:
				return generalOrderings != null && !generalOrderings.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__MESSAGES:
				return messages != null && !messages.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION:
				return getInteraction() != null;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__DEFAULT_APPLICATION:
				return defaultApplication != null;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				return interactionOperator != INTERACTION_OPERATOR_EDEFAULT;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				return gates != null && !gates.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return interactionOperands != null && !interactionOperands.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (interactionOperator: ");
		result.append(interactionOperator);
		result.append(')');
		return result.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ILoop#getCondition()
	 */
	public ICondition getCondition() {
		if(getInteractionOperands() != null && getInteractionOperands().size() != 0)
		{
			BVRInteractionOperandImpl interactionOperand = (BVRInteractionOperandImpl)getInteractionOperands().get(0);
			return (BVRInteractionConstraintImpl)interactionOperand.getInteractionConstraint();
		}
		return null; 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDecision#getFailureBlock()
	 */
	public IBlock getFailureBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.ALT)
		{
			// By convention, a if statement has two interaction operands where the first 
			// one is success and the second is failure.
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(1);
			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDecision#getSuccessBlock()
	 */
	public IBlock getSuccessBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.ALT)
		{
			// By convention, a if statement has two interaction operands where the first 
			// one is success and the second is failure.
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(0);

			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ILoop#getBlock()
	 */
	public IBlock getBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.LOOP)
		{
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(0);
			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}			
		}
		return null;
	}

	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
	
	
} //BVRCombinedFragmentImpl
