/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Deployment</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getLocations <em>Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getRefLocations <em>Ref Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getArtifactLocations <em>Artifact Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getTestSuites <em>Test Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getCFGArtifact <em>CFG Artifact</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getArtifacts <em>Artifacts</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment()
 * @model 
 * @generated
 */
public interface TPFDeployment extends CFGConfigurableObject{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Locations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGLocation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment <em>Deployment</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Locations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Locations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_Locations()
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGLocation" opposite="deployment" containment="true"
	 * @generated
	 */
	EList getLocations();

	/**
	 * Returns the value of the '<em><b>Ref Locations</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGLocation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ref Locations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Locations</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_RefLocations()
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGLocation"
	 * @generated
	 */
	EList getRefLocations();

	/**
	 * Returns the value of the '<em><b>Artifact Locations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Artifact Locations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Artifact Locations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_ArtifactLocations()
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair" containment="true"
	 * @generated
	 */
	EList getArtifactLocations();

	/**
	 * Returns the value of the '<em><b>Test Suites</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFTestSuite}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Suites</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Suites</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_TestSuites()
	 * @model type="org.eclipse.hyades.models.common.testprofile.TPFTestSuite"
	 * @generated
	 */
	EList getTestSuites();

	/**
	 * Returns the value of the '<em><b>CFG Artifact</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CFG Artifact</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CFG Artifact</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_CFGArtifact()
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGArtifact"
	 * @generated
	 */
	EList getCFGArtifact();

	/**
	 * Returns the value of the '<em><b>Artifacts</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Artifacts</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Artifacts</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFDeployment_Artifacts()
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGArtifact"
	 * @generated
	 */
	EList getArtifacts();

} // TPFDeployment
