/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Test Case</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl#getTestSuite <em>Test Suite</em>}</li>
 * </ul>
 * </p>
 *
 * @extends ITestCase
 * @generated NOT
 */
public class TPFTestCaseImpl extends TPFTestImpl implements TPFTestCase, ITestCase
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getInstances() <em>Instances</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected EList instances = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFTestCaseImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_TestprofilePackage.eINSTANCE.getTPFTestCase();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestSuite getTestSuite()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE) return null;
		return (TPFTestSuite)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestSuite(TPFTestSuite newTestSuite)
	{
		if (newTestSuite != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE && newTestSuite != null)) {
			if (EcoreUtil.isAncestor(this, newTestSuite))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestSuite != null)
				msgs = ((InternalEObject)newTestSuite).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES, TPFTestSuite.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTestSuite, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE, newTestSuite, newTestSuite));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInstances()
	{
		if (instances == null) {
			instances = new EObjectContainmentWithInverseEList(CFGInstance.class, this, Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE);
		}
		return instances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
					return ((InternalEList)getTestObjectives()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
					if (behavior != null)
						msgs = ((InternalEObject)behavior).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR, null, msgs);
					return basicSetBehavior((TPFBehavior)otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
					return ((InternalEList)getInstances()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
					return ((InternalEList)getTestObjectives()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
					return basicSetBehavior(null, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE, msgs);
				case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
					return ((InternalEList)getInstances()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES, TPFTestSuite.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_CASE__ID:
				return getId();
			case Common_TestprofilePackage.TPF_TEST_CASE__DESCRIPTION:
				return getDescription();
			case Common_TestprofilePackage.TPF_TEST_CASE__NAME:
				return getName();
			case Common_TestprofilePackage.TPF_TEST_CASE__TYPE:
				return getType();
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
				return getTestObjectives();
			case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
				return getBehavior();
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
				return getTestSuite();
			case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
				return getInstances();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_CASE__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__NAME:
				setName((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TYPE:
				setType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
				getTestObjectives().clear();
				getTestObjectives().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
				setBehavior((TPFBehavior)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
				setTestSuite((TPFTestSuite)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_CASE__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
				getTestObjectives().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
				setBehavior((TPFBehavior)null);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
				setTestSuite((TPFTestSuite)null);
				return;
			case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
				getInstances().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_CASE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_TEST_CASE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_TestprofilePackage.TPF_TEST_CASE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_TestprofilePackage.TPF_TEST_CASE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_OBJECTIVES:
				return testObjectives != null && !testObjectives.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
				return behavior != null;
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
				return getTestSuite() != null;
			case Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES:
				return instances != null && !instances.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestCase#getOwner()
	 */
	public ITestSuite getOwner() {
		return (TPFTestSuiteImpl)getTestSuite();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getImplementor()
	 */
	public IImplementor getImplementor() {
		return (TPFBehaviorImpl)getBehavior();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getVariables()
	 */
	public List getVariables() {
		return getInstances();
	}

} //TPFTestCaseImpl
