/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.AddChildAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles the add action in {@link CFGConfigurableObject} editing page to add new 
 * {@link CFGComparableProperty}. Subclass can override {@link #addProperties()} to do specific
 * actions when the add button is selected.
 * 
 * @author bjiang
 * @since  1.3
 */
public abstract class AddConfigPropertyAction extends AddChildAction
{
	private CFGPropertyGroup parent;
	
	/**
	 * Constructor for AddConfigPropertyAction
	 * @param parent the CFGPropertyGroup the new property belongs to
	 * @param image the image for the property this action adds, or <code>null</code> if no image.
	 */
	public AddConfigPropertyAction(CFGPropertyGroup parent, ImageDescriptor image)
	{
		super(Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup(), TestUIPlugin.getString("BTN_ADD"));	 //$NON-NLS-1$
		this.parent = parent;
		super.setParent(parent);
		if( image != null )
			super.setImageDescriptor(image);	
	}

	/**
	 * Sets the default CFGPropertyGroup that is returned by 
	 * {@link #getParentPropertyGroup(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the CFGPropertyGroup.
	 * @param parent
	 */
	public void setPropertyGroup(CFGPropertyGroup parent)
	{
		this.parent = parent;
		super.setParent(parent);
	}

	/**
	 * Returns the CFGPropertyGroup that contains the first element of the structured 
	 * selection if there is no default property group or <code>null</code>.
	 * @param structuredSelection
	 * @return CFGPropertyGroup
	 */
	protected CFGPropertyGroup getPropertyGroup(IStructuredSelection structuredSelection)
	{
		if( parent != null )
			return parent;
		return (CFGPropertyGroup)super.getParent(structuredSelection);
	}	
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		CFGComparableProperty[] newProperties = addProperties();
		if(newProperties == null || newProperties.length == 0)
			return;
			
		for(int i = 0; i < newProperties.length; i++)
		{				
			parent.getProperties().add(newProperties[i]);
		}
	}
	
	protected abstract CFGComparableProperty[] addProperties();

}
