/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.wizard.LocationNewWizard;
import org.eclipse.hyades.test.ui.internal.wizard.selection.ResourceSelectionWizard;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/**
 * We are creating only machines at this moment.
 * 
 * @author marcelop
 * @since 0.2.0
 * @author bjiang
 * @since 1.3
 */
public class AddLocationAction 
extends AddDeploymentChildAction
{
	/**
	 * Constructor for AddLocationAction
	 */
	public AddLocationAction()
	{
		super(TestUIPlugin.getString("BTN_ADD")); //$NON-NLS-1$
		
		setToolTipText(TestUIPlugin.getString("ACT_LOC_ADD_TIP")); //$NON-NLS-1$
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_LOCATION));
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getDeployment(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		LocationNewWizard locationNewWizard = new LocationNewWizard();
		WizardElement newFileWizardElement = new WizardElement(locationNewWizard);
		ResourceSelectionWizard fileSelectionWizard = new ResourceSelectionWizard(newFileWizardElement, locationNewWizard.getFileExtension(), TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION));
		fileSelectionWizard.setWindowTitle(TestUIPlugin.getString("DLG_ASS_LOC"));					 //$NON-NLS-1$
		fileSelectionWizard.init(PlatformUI.getWorkbench(), new StructuredSelection());

		Shell parent = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(parent, fileSelectionWizard);
		dialog.create();
		int ret = dialog.open();
		if(ret == WizardDialog.OK)
		{
			EObject[] eObjects = fileSelectionWizard.getSelectedEObjects();
			if(eObjects != null && eObjects.length > 0)
			{
				TPFDeployment deployment = getDeployment(getStructuredSelection());
				for(int i = 0; i < eObjects.length; i++)
				{
					if(eObjects[i] instanceof CFGLocation)			
					{
						boolean exists = false;
						for(Iterator it = deployment.getRefLocations().iterator(); it.hasNext();)
						{
							if(((CFGLocation)it.next()).getId().equals(((CFGLocation)eObjects[i]).getId()))
							{
								exists = true;
								break;
							}
						}
						if(!exists)
							deployment.getRefLocations().add((CFGLocation)eObjects[i]);		
					}						
				}
			}
		}
		
/*		TPFDeployment deployment = getDeployment(getStructuredSelection());
		
		// create new location resource
		String name = TestUIUtil.getUniqueName(TestUIPlugin.getString("W_LOC"), deployment.getRefLocations());
		String filename = name + "." + LocationResourceFactory.getFileExtension();		
		IFile deployFile = EMFUtil.getWorkspaceFile(deployment);
		IFile file = deployFile.getWorkspace().getRoot().getFile( deployFile.getParent().getFullPath().append(filename));
		
		try	
		{
			EObject machine = LocationResourceFactory.create(file, name, "" );			
			deployment.getRefLocations().add(machine);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
*/
	}		
}
