/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.test.ui.internal.editor.form.PropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.LocationForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Hyades configurable object editor extension that is suitable for all {@link CFGLocation} objects.
 * 
 * @author bjiang
 * @since	1.3
 */
public class LocationEditorExtension extends ConfigurableObjectEditorExtension 
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Location"; //$NON-NLS-1$
	
	protected IConfigurationElement[] collectRegisteredExtensionElements() 
	{
		IConfigurationElement[] extensions = super.collectRegisteredExtensionElements();		
		Vector registeredExts = new Vector();		 
		{
			for( int i = 0; i < extensions.length; i++ )
			{
			   if( extensions[i].getAttribute("appliesTo").equals(PropertyGroupForm.EDITOR_TYPE_LOCATION)) //$NON-NLS-1$
			   {
				   registeredExts.add( extensions[i] );
			   }
			}
		}	
		
		if( extensions.length == registeredExts.size() )
			return extensions;	
		
		IConfigurationElement[] registeredExtensions = new IConfigurationElement[registeredExts.size()];
		for( int i = 0; i < registeredExts.size(); i++ )
		{
			registeredExtensions[i] = (IConfigurationElement)registeredExts.get(i);
		}
		return registeredExtensions;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory)
	{
		return new LocationForm(this, widgetFactory);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.IExtensibleEditorExtension#activateExtensionPage(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public int addExtensionPage(IConfigurationElement extensionElement) 
	{
		// if this extension element is not intended for location editor, return -1.
	   	if( !extensionElement.getAttribute("appliesTo").equals(PropertyGroupForm.EDITOR_TYPE_LOCATION)) //$NON-NLS-1$
		    return -1;
		    
		return super.addExtensionPage(extensionElement);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		super.setSelection( structuredSelection );
		
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object instanceof CFGLocation)
			{
				getHyadesEditorPart().setActivePage(PAGE_OVERVIEW);
				getOverviewForm().selectReveal(structuredSelection);
			}
		}
	}	
}
