/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DataTableForm extends EditorForm {

	DatapoolEditorExtension datapoolEditorExtension = null;

	/**
	 * Constructor for DataTableForm
	 * @param datapoolEditorExtension
	 * @param widgetFactory
	 */
	public DataTableForm(DatapoolEditorExtension datapoolEditorExtension, WidgetFactory widgetFactory)
	{
		super(datapoolEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DATAPOOL"));
		this.datapoolEditorExtension = datapoolEditorExtension;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		super.dispose();
	}

	/**
	 * Returns the datapool manipulated by this form.
	 * @return DPLDatapool
	 */
	protected DPLDatapool getDatapool()
	{
		return ((DatapoolEditorExtension)getBaseEditorExtension()).getDatapool();		
	}

	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.DATA_TABLE_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);
	
		DatapoolTable table = new DatapoolTable(parent, 
												datapoolEditorExtension,
												(IDatapool)getDatapool(),
												(IDatapoolFactory)Common_DatapoolFactoryImpl.eINSTANCE);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#load()
	 */
	public void load() {
		// TODO Auto-generated method stub

	}

}
