/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NodeGeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This class implements the overview page of the location resource editor.
 * 
 * @author bjiang
 * @since	1.3
 */
public class LocationForm extends ConfigurableObjectOverviewForm 
{
	/**
	 * Constructor for LocationOverviewForm
	 * @param locationEditorExtension
	 * @param widgetFactory
	 */
	public LocationForm(ConfigurableObjectEditorExtension locationEditorExtension, WidgetFactory widgetFactory)
	{
		super(locationEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_LOCATION")); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.LOC_FORM);
		return control;
	}
	
	protected void createGeneralInfoSection(Composite parent) 
	{
		GeneralInfoSection generalInfoSection = new NodeGeneralInfoSection(this, true);
		generalInfoSection.setEditable(true);
		registerSection(generalInfoSection);		
		Control control = generalInfoSection.createControl(parent, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);		
		setGeneralInfoSectionHelp(control);
		setGeneralInfoSection(generalInfoSection);
	}

}
