/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddSUTAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class SUTsForm
extends EditorForm implements ISelectionChangedListener
{
	private EObjectTreeSection sutsSection;
	private NamedElementSection namedElementSection;
	private AddSUTAction addSUTAction;
	private boolean firstActivation = true;
	
	/**
	 * Constructor for TestCasesForm
	 * @param testSuiteEditorExtension
	 * @param widgetFactory
	 */
	public SUTsForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_SUTS"));
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		sutsSection.getTreeViewer().removeSelectionChangedListener(this);
		sutsSection.dispose();
		namedElementSection.dispose();
		addSUTAction.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the test case suite manipulated by this form.
	 * @return TPFTestSuite
	 */
	protected TPFTestSuite getTestSuite()
	{
		return ((TestSuiteEditorExtension)getBaseEditorExtension()).getTestSuite();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.SUT_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		addSUTAction = new AddSUTAction();
		sutsSection = new EObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_SUTs(), addSUTAction);
		registerSection(sutsSection);
		sutsSection.setHeaderText(TestUIPlugin.getString("W_SUTS"));
		sutsSection.setCollapsable(true);
		Control control = sutsSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
				
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.SUT_SECTION_FORM);										
		WorkbenchHelp.setHelp(sutsSection.getTreeViewer().getControl(), TestUIPlugin.getID() + ContextIds.SUT_TREE_FORM);										
		
		namedElementSection = new NamedElementSection(this);
		namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
		registerSection(namedElementSection);		
		control = namedElementSection.createControl(rightColumn, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);	
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.SUT_NAME_FORM);										
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		addSUTAction.setTestSuite(getTestSuite());		

		sutsSection.getTreeViewer().removeSelectionChangedListener(this);
		sutsSection.setInput(getTestSuite());
		sutsSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		sutsSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == sutsSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			namedElementSection.setInput(structuredSelection);
		}
	}
	
	public ISelection getSelection()
	{
		return sutsSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			sutsSection.setFocus();
		}
			
		return super.activated();
	}
}
