/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * This class implements a general info section of a resource editor.
 * 
 * @author bjiang
 * @since  1.3
 */
public class GeneralInfoSection extends NamedElementSection 
{
	private StyledText fileText;
	boolean displayResourceFileInfo = false;
	private boolean editable;
	
	/**
	 * Constructor for NamedElementSection
	 * @param editorForm 
	 * @param displayResourceFileInfo	
	 */
	public GeneralInfoSection(EditorForm editorForm, boolean hasResourceFileInfo)
	{
		super(editorForm);
		this.displayResourceFileInfo = hasResourceFileInfo;
		setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO")); //$NON-NLS-1$
		setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC")); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		super.dispose();
		fileText.dispose();
	}
			
	protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		if(displayResourceFileInfo == false)
			return;
		
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();	
		Composite detailComposite = widgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		detailComposite.setLayout(gridLayout);
		detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_FILE")); //$NON-NLS-1$
		fileText = widgetFactory.createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
		fileText.setEnabled(false);
		fileText.setLayoutData(GridDataUtil.createHorizontalFill());		
	}

	public void setInput(Object object)
	{
		super.setInput(object);
		if(displayResourceFileInfo == false)
			return;		
		
		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection selection = (IStructuredSelection)object;
			if( selection.size() == 1 )
			{
				IFile file = EMFUtil.getWorkspaceFile((EObject)selection.getFirstElement());
				if(file != null)
					getFileText().setText(file.getFullPath().toString());
			}
		}	
	
		if(object instanceof EObject)
		{
			IFile file = EMFUtil.getWorkspaceFile((EObject)object);
			if(file != null)
				getFileText().setText(file.getFullPath().toString());
		}
		
		setEditable(editable);						
	}

	protected StyledText getFileText()
	{
		return fileText;
	}
	
	public void setEditable(boolean isEditable)
	{
		this.editable = isEditable;
		if(getNameTextField() != null)
			getNameTextField().setEditable(editable);
		
		if(getDescriptionTextField() != null)
			getDescriptionTextField().setEditable(editable);
	}
	
	public boolean isEditable()
	{
		return this.editable;
	}
}
