/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ListIterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles the move down action of elements that are {@link org.eclipse.emf.ecore.EStructuralFeature}
 * of an {@link org.eclipse.emf.ecore.EObject}.
 * 
 * @author bjiang
 * @since  1.3
 */
public class MoveDownChildrenAction extends ChildrenSelectionAction
{
	/**
	 * @param parent
	 * @param feature
	 */
	public MoveDownChildrenAction(EObject parent, EStructuralFeature feature)
	{
		super(TestUIPlugin.getString("LBL_DOWN"), parent, feature); //$NON-NLS-1$
		
		setToolTipText(TestUIPlugin.getString("ACT_DOWN_DSC")); //$NON-NLS-1$
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_DOWN);
	}
	
	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(!super.updateSelection(selection))
			return false;
			
		EList allChildren = getEStructuralFeatureValue();

		if(allChildren.size() <= 1)
		{
			getChilren().clear();
			return false;
		}
			
		if((getChilren().size() == 1) && (allChildren.get(allChildren.size()-1) == getChilren().get(0)))
		{
			getChilren().clear();
			return false;			
		}
				
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		EList allChildren = getEStructuralFeatureValue();
		if(allChildren.size() <= 1)
			return;

		int botton = allChildren.size()-1;
		for(ListIterator i=getChilren().listIterator(getChilren().size()); i.hasPrevious(); )
		{
			Object element = i.previous();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;

			if(index < botton)
			{
				allChildren.move(index, index+1);
			}
			else
			{
				botton--;
			}
		}

		setActionPerformed(true);
	}	
}
