/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Feb 20, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;


/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogThreadInteractions extends LogInteractions {
	
	private List threadIDs = new UniqueEList();
	static{		
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_LOGS] = new LifelineCategories();
		traceCategories[CATEGORY_LOGS].setName(""); 
		image = SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_THREAD);
		traceCategories[CATEGORY_LOGS].setImage(image); 
	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#loadEvents(java.util.List)
	 */
	protected void loadEvents() {

		if(!isDisplayingOnlyCorrelations()){
			loadThreadIdsFromAgentList(true);
		}else{
			loadThreadIdsFromAgentList(false);
			loadEventsFromCorrelations();
		}
	}
	
	private void loadThreadIdsFromAgentList(boolean addEvents) {
		for (Iterator iter = agentsList.iterator(); iter.hasNext();) {
			TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
			if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
			{				
				loadThreadIdsFromAgent(trcAgentProxy);
				if (addEvents) addEvents(trcAgentProxy);
			}
		}
	}
	
	private void loadThreadIdsFromAgent(TRCAgentProxy agentProxy){
		
		List events = agentProxy.getAgent().getDefaultEvents();
		CBECommonBaseEvent artifact = null;
		String threadID = null;
		
		for (Iterator iter = events.iterator(); iter.hasNext();) {
			artifact = (CBECommonBaseEvent)iter.next();
			
			threadID = artifact.getSourceComponentId().getThreadId();
			if (threadID==null)
				threadID="-1";
			threadIDs.add(agentProxy.getName()+" - "+"TID:" + threadID);
		}				
	}
		
	protected void generateLifelines(){
		String id = null;
		for (Iterator iter = getLifelineArtifactsList().iterator(); iter.hasNext();) {
			id = (String)iter.next();
			TraceLifeline lifeLine = new TraceLifeline();
			lifeLine.setName(id);
			lifeLine.setCategory(CATEGORY_LOGS);				
			frame.addLifeLine(lifeLine);
			lifelinesMap.put(id, lifeLine);
		}

	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#getLifelinesMapKey(org.eclipse.hyades.models.cbe.CBECommonBaseEvent)
	 */
	protected Object getLifelinesMapKey(CBECommonBaseEvent element) {

		String threadID = element.getSourceComponentId().getThreadId();
		if(threadID==null){
			threadID = "-1";
		}
		return element.getAgent().getAgentProxy().getName()+" - "+"TID:" + threadID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		String title = SDLogcPlugin.getString("STR_VIEW_TITLE") +": "+ SDLogcPlugin.getString("STR_MENU_LOT");
		if(correlationContainerProxy!=null){
			title = title + " <"+correlationContainerProxy.getCorrelationEngine().getName()+"> ";
		}
		return title;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#getLifelineArtifactsList()
	 */
	protected List getLifelineArtifactsList() {
		
		return threadIDs;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#clearDiagramCaches()
	 */
	protected void clearDiagramCaches() {		
		threadIDs.clear();
		super.clearDiagramCaches();		
	}
	
	protected String getFrameTitle(){
		return SDLogcPlugin.getString("STR_MENU_LOT")+ ":      " + getFrameName();
	}
	

}
