/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.trace.ui.internal.util.CorrelationUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;


public class LogCorrelationSelectionDialog extends Dialog {
	
	private IExtension[] extensions;	
	private CorrelationUI correlationUI;

	public LogCorrelationSelectionDialog(Shell parent, IExtension[] ext){
		super(parent);
		extensions = ext;		
	}
	
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(SDLogcPlugin.getString("STR_SELECT_CORRELATION"));
	}
	
	protected Control createDialogArea(Composite parent) {
		correlationUI = new CorrelationUI(extensions);
		Control uiControl = correlationUI.createControl(parent);
		WorkbenchHelp.setHelp(uiControl,ContextIds.CORRELATION_DIALOG);
		return uiControl;
	}
	
	public void widgetSelected(SelectionEvent e)
	{
	   if(e.widget == correlationUI.getCorrelationNames())
	      selectCorrelation(correlationUI.getCorrelationNames().getSelectionIndex());
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
		okPressed();
	}
	
	
	protected void okPressed() {
		
		correlationUI.setCorrelation(correlationUI.getSelectedCorrelation());		
		super.okPressed();
	}

	public IConfigurationElement getSelectedCorrelation(){
		
	   return correlationUI.getCorrelation();	
	}
 
    /**
     * 
     * @param index
     */
    public void selectCorrelation(int index)
    {
		correlationUI.selectCorrelation(index);
    }
     
}
