/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.StatisticalPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCDescriptionImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SDDescriptorImpl extends AbstractTRCDescriptionImpl implements SDDescriptor {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList children = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDDescriptorImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return StatisticalPackage.eINSTANCE.getSDDescriptor();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId)
	{
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_DESCRIPTOR__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription)
	{
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_DESCRIPTOR__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName)
	{
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_DESCRIPTOR__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getChildren()
	{
		if (children == null) {
			children = new EObjectContainmentWithInverseEList(SDDescriptor.class, this, StatisticalPackage.SD_DESCRIPTOR__CHILDREN, StatisticalPackage.SD_DESCRIPTOR__PARENT);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDDescriptor getParent()
	{
		if (eContainerFeatureID != StatisticalPackage.SD_DESCRIPTOR__PARENT) return null;
		return (SDDescriptor)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(SDDescriptor newParent)
	{
		if (newParent != eContainer || (eContainerFeatureID != StatisticalPackage.SD_DESCRIPTOR__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, StatisticalPackage.SD_DESCRIPTOR__CHILDREN, SDDescriptor.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, StatisticalPackage.SD_DESCRIPTOR__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_DESCRIPTOR__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_DESCRIPTOR__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_DESCRIPTOR__AGENT, msgs);
				case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
					return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
				case StatisticalPackage.SD_DESCRIPTOR__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_DESCRIPTOR__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_DESCRIPTOR__AGENT:
					return eBasicSetContainer(null, StatisticalPackage.SD_DESCRIPTOR__AGENT, msgs);
				case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
					return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
				case StatisticalPackage.SD_DESCRIPTOR__PARENT:
					return eBasicSetContainer(null, StatisticalPackage.SD_DESCRIPTOR__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case StatisticalPackage.SD_DESCRIPTOR__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__DESCRIPTOR, TRCAgent.class, msgs);
				case StatisticalPackage.SD_DESCRIPTOR__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, StatisticalPackage.SD_DESCRIPTOR__CHILDREN, SDDescriptor.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_DESCRIPTOR__AGENT:
				return getAgent();
			case StatisticalPackage.SD_DESCRIPTOR__ID:
				return getId();
			case StatisticalPackage.SD_DESCRIPTOR__NAME:
				return getName();
			case StatisticalPackage.SD_DESCRIPTOR__DESCRIPTION:
				return getDescription();
			case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
				return getChildren();
			case StatisticalPackage.SD_DESCRIPTOR__PARENT:
				return getParent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_DESCRIPTOR__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__ID:
				setId((String)newValue);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__NAME:
				setName((String)newValue);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__PARENT:
				setParent((SDDescriptor)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_DESCRIPTOR__AGENT:
				setAgent((TRCAgent)null);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__ID:
				setId(ID_EDEFAULT);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
				getChildren().clear();
				return;
			case StatisticalPackage.SD_DESCRIPTOR__PARENT:
				setParent((SDDescriptor)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_DESCRIPTOR__AGENT:
				return getAgent() != null;
			case StatisticalPackage.SD_DESCRIPTOR__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case StatisticalPackage.SD_DESCRIPTOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case StatisticalPackage.SD_DESCRIPTOR__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case StatisticalPackage.SD_DESCRIPTOR__CHILDREN:
				return children != null && !children.isEmpty();
			case StatisticalPackage.SD_DESCRIPTOR__PARENT:
				return getParent() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //SDDescriptorImpl
